/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class GL30 {
    public static String glGetStringi(int name, int index) {
        if (Properties.PROFILE.enabled && name == 7939) {
            int numExtensions;
            int GREMEDY_string_marker_index = numExtensions = GL11.glGetInteger(33309);
            int GREMEDY_frame_terminator_index = numExtensions + 1;
            if (index == GREMEDY_string_marker_index) {
                return "GREMEDY_string_marker";
            }
            if (index == GREMEDY_frame_terminator_index) {
                return "GREMEDY_frame_terminator";
            }
        }
        return org.lwjgl.opengl.GL30.glGetStringi(name, index);
    }

    public static void glGenerateMipmap(int target) {
        org.lwjgl.opengl.GL30.glGenerateMipmap(target);
        if (Properties.PROFILE.enabled) {
            RT.generateMipmap(target);
        }
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = pointer != null;
        }
        org.lwjgl.opengl.GL30.glVertexAttribIPointer(index, size, type, stride, pointer);
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        int vbo;
        if (Properties.VALIDATE.enabled && index > -1 && (vbo = GL11.glGetInteger(34964)) != 0) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = true;
        }
        org.lwjgl.opengl.GL30.glVertexAttribIPointer(index, size, type, stride, pointer);
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ShortBuffer pointer) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = pointer != null;
        }
        org.lwjgl.opengl.GL30.glVertexAttribIPointer(index, size, type, stride, pointer);
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, IntBuffer pointer) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = pointer != null;
        }
        org.lwjgl.opengl.GL30.glVertexAttribIPointer(index, size, type, stride, pointer);
    }

    public static void glGenVertexArrays(IntBuffer arrays) {
        org.lwjgl.opengl.GL30.glGenVertexArrays(arrays);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            int position = arrays.position();
            for (int i = 0; i < arrays.remaining(); ++i) {
                Context.VAO vao = new Context.VAO(context.GL_MAX_VERTEX_ATTRIBS);
                context.vaos.put(arrays.get(position + i), vao);
            }
        }
    }

    public static int glGenVertexArrays() {
        int index = org.lwjgl.opengl.GL30.glGenVertexArrays();
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            Context.VAO vao = new Context.VAO(context.GL_MAX_VERTEX_ATTRIBS);
            context.vaos.put(index, vao);
        }
        return index;
    }

    public static void glGenVertexArrays(int[] arrays) {
        org.lwjgl.opengl.GL30.glGenVertexArrays(arrays);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < arrays.length; ++i) {
                Context.VAO vao = new Context.VAO(context.GL_MAX_VERTEX_ATTRIBS);
                context.vaos.put(arrays[i], vao);
            }
        }
    }

    public static void glBindVertexArray(int index) {
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            Context.VAO vao = ctx.vaos.get(index);
            if (vao == null && ctx.shareGroup != null) {
                for (Context c : ctx.shareGroup.contexts) {
                    if (!c.vaos.containsKey(index)) continue;
                    RT.throwISEOrLogError("Trying to bind unknown VAO [" + index + "] from shared context [" + c.counter + "]");
                }
            }
            ctx.currentVao = vao;
        }
        org.lwjgl.opengl.GL30.glBindVertexArray(index);
    }

    public static void glDeleteVertexArrays(int[] indices) {
        org.lwjgl.opengl.GL30.glDeleteVertexArrays(indices);
        if (Properties.VALIDATE.enabled) {
            Context.deleteVertexArrays(indices);
        }
    }

    public static void glDeleteVertexArrays(IntBuffer indices) {
        org.lwjgl.opengl.GL30.glDeleteVertexArrays(indices);
        if (Properties.VALIDATE.enabled) {
            Context.deleteVertexArrays(indices);
        }
    }

    public static void glDeleteVertexArrays(int index) {
        org.lwjgl.opengl.GL30.glDeleteVertexArrays(index);
        if (Properties.VALIDATE.enabled) {
            Context.deleteVertexArray(index);
        }
    }

    public static void glGenFramebuffers(IntBuffer framebuffers) {
        org.lwjgl.opengl.GL30.glGenFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            int pos = framebuffers.position();
            for (int i = 0; i < framebuffers.remaining(); ++i) {
                int handle = framebuffers.get(pos + i);
                Context.FBO fbo = new Context.FBO(handle);
                ctx.fbos.put(handle, fbo);
            }
        }
    }

    public static int glGenFramebuffers() {
        int handle = org.lwjgl.opengl.GL30.glGenFramebuffers();
        if (Properties.VALIDATE.enabled) {
            Context.FBO fbo = new Context.FBO(handle);
            Context ctx = Context.CURRENT_CONTEXT.get();
            ctx.fbos.put(handle, fbo);
        }
        return handle;
    }

    public static void glGenFramebuffers(int[] framebuffers) {
        org.lwjgl.opengl.GL30.glGenFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < framebuffers.length; ++i) {
                int handle = framebuffers[i];
                Context.FBO fbo = new Context.FBO(handle);
                ctx.fbos.put(handle, fbo);
            }
        }
    }

    public static void glBindFramebuffer(int target, int framebuffer) {
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            Context.FBO fbo = ctx.fbos.get(framebuffer);
            if (fbo == null && ctx.shareGroup != null) {
                for (Context c : ctx.shareGroup.contexts) {
                    if (!c.fbos.containsKey(framebuffer)) continue;
                    RT.throwISEOrLogError("Trying to bind unknown FBO [" + framebuffer + "] from shared context [" + c.counter + "]");
                }
            }
            ctx.currentFbo = fbo;
        }
        org.lwjgl.opengl.GL30.glBindFramebuffer(target, framebuffer);
    }

    public static void glDeleteFramebuffers(IntBuffer framebuffers) {
        org.lwjgl.opengl.GL30.glDeleteFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            int pos = framebuffers.position();
            for (int i = 0; i < framebuffers.remaining(); ++i) {
                int framebuffer = framebuffers.get(pos + i);
                if (framebuffer == 0) continue;
                Context.FBO fbo = context.fbos.get(framebuffer);
                if (fbo != null && fbo == context.currentFbo) {
                    context.currentFbo = context.defaultFbo;
                }
                context.fbos.remove(framebuffer);
            }
        }
    }

    public static void glDeleteFramebuffers(int framebuffer) {
        org.lwjgl.opengl.GL30.glDeleteFramebuffers(framebuffer);
        if (Properties.VALIDATE.enabled) {
            if (framebuffer == 0) {
                return;
            }
            Context context = Context.CURRENT_CONTEXT.get();
            Context.FBO fbo = context.fbos.get(framebuffer);
            if (fbo != null && fbo == context.currentFbo) {
                context.currentFbo = context.defaultFbo;
            }
            context.fbos.remove(framebuffer);
        }
    }

    public static void glDeleteFramebuffers(int[] framebuffers) {
        org.lwjgl.opengl.GL30.glDeleteFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < framebuffers.length; ++i) {
                int framebuffer = framebuffers[i];
                if (framebuffer == 0) continue;
                Context.FBO fbo = context.fbos.get(framebuffer);
                if (fbo != null && fbo == context.currentFbo) {
                    context.currentFbo = context.defaultFbo;
                }
                context.fbos.remove(framebuffer);
            }
        }
    }
}

