/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.GLmetadata;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.MethodCall;
import org.lwjglx.debug.Properties;

public class GL20 {
    public static void glEnableVertexAttribArray(int index) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.enabledVertexArrays[index] = true;
        }
        org.lwjgl.opengl.GL20.glEnableVertexAttribArray(index);
    }

    public static void glDisableVertexAttribArray(int index) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.enabledVertexArrays[index] = false;
        }
        org.lwjgl.opengl.GL20.glDisableVertexAttribArray(index);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, FloatBuffer pointer) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = pointer != null;
        }
        org.lwjgl.opengl.GL20.glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer pointer) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = pointer != null;
        }
        org.lwjgl.opengl.GL20.glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, IntBuffer pointer) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = pointer != null;
        }
        org.lwjgl.opengl.GL20.glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ShortBuffer pointer) {
        if (Properties.VALIDATE.enabled && index > -1) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = pointer != null;
        }
        org.lwjgl.opengl.GL20.glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        int vbo;
        if (Properties.VALIDATE.enabled && index > -1 && (vbo = GL11.glGetInteger(34964)) != 0) {
            Context.CURRENT_CONTEXT.get().currentVao.initializedVertexArrays[index] = true;
        }
        org.lwjgl.opengl.GL20.glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glCompileShader(int shader) {
        int status;
        org.lwjgl.opengl.GL20.glCompileShader(shader);
        if (Properties.VALIDATE.enabled && (status = org.lwjgl.opengl.GL20.glGetShaderi(shader, 35713)) != 1) {
            String shaderLog = org.lwjgl.opengl.GL20.glGetShaderInfoLog(shader);
            Log.error("Shader [" + shader + "] did not compile successfully:\n" + shaderLog);
        }
    }

    public static void glLinkProgram(int program) {
        int status;
        org.lwjgl.opengl.GL20.glLinkProgram(program);
        if (Properties.VALIDATE.enabled && (status = org.lwjgl.opengl.GL20.glGetProgrami(program, 35714)) != 1) {
            String programLog = org.lwjgl.opengl.GL20.glGetProgramInfoLog(program);
            Log.error("Program [" + program + "] did not link successfully:\n" + programLog);
        }
    }

    public static void glShaderSource(int shader, PointerBuffer strings, IntBuffer length) {
        org.lwjgl.opengl.GL20.glShaderSource(shader, strings, length);
        if (Properties.TRACE.enabled) {
            StringBuilder sb = new StringBuilder();
            if (strings != null && length != null) {
                int stringsPos = strings.position();
                int lengthPos = length.position();
                for (int i = 0; i < strings.remaining(); ++i) {
                    int len = length.get(lengthPos + i);
                    ByteBuffer string = MemoryUtil.memByteBuffer(strings.get(stringsPos + i), len);
                    String source = MemoryUtil.memASCII(string, len);
                    sb.append(source);
                }
            }
            Log.trace("Shader source for shader [" + shader + "]:\n" + sb.toString());
        }
    }

    public static void glShaderSource(int shader, CharSequence ... strings) {
        org.lwjgl.opengl.GL20.glShaderSource(shader, strings);
        if (Properties.TRACE.enabled) {
            StringBuilder sb = new StringBuilder();
            if (strings != null) {
                for (int i = 0; i < strings.length; ++i) {
                    sb.append(strings[i]);
                }
            }
            Log.trace("Shader source for shader [" + shader + "]:\n" + sb.toString());
        }
    }

    public static void glShaderSource(int shader, CharSequence string) {
        org.lwjgl.opengl.GL20.glShaderSource(shader, string);
        if (Properties.TRACE.enabled) {
            Log.trace("Shader source for shader [" + shader + "]:\n" + string);
        }
    }

    public static void glGetShaderi(int shader, int pname, int ret, MethodCall mc) {
        mc.param(shader);
        mc.paramEnum(GLmetadata._null_().get(pname));
        switch (pname) {
            case 35713: {
                mc.returnValueEnum(GLmetadata.Boolean().get(ret));
                break;
            }
            default: {
                mc.param(pname);
            }
        }
    }

    public static void glGetProgrami(int program, int pname, int ret, MethodCall mc) {
        mc.param(program);
        mc.paramEnum(GLmetadata._null_().get(pname));
        switch (pname) {
            case 35714: {
                mc.returnValueEnum(GLmetadata.Boolean().get(ret));
                break;
            }
            default: {
                mc.param(pname);
            }
        }
    }
}

