/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.nio.IntBuffer;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class ARBVertexArrayObject {
    public static void glGenVertexArrays(IntBuffer arrays) {
        org.lwjgl.opengl.ARBVertexArrayObject.glGenVertexArrays(arrays);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            int position = arrays.position();
            for (int i = 0; i < arrays.remaining(); ++i) {
                Context.VAO vao = new Context.VAO(context.GL_MAX_VERTEX_ATTRIBS);
                context.vaos.put(arrays.get(position + i), vao);
            }
        }
    }

    public static int glGenVertexArrays() {
        int index = org.lwjgl.opengl.ARBVertexArrayObject.glGenVertexArrays();
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            Context.VAO vao = new Context.VAO(context.GL_MAX_VERTEX_ATTRIBS);
            context.vaos.put(index, vao);
        }
        return index;
    }

    public static void glGenVertexArrays(int[] arrays) {
        org.lwjgl.opengl.ARBVertexArrayObject.glGenVertexArrays(arrays);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < arrays.length; ++i) {
                Context.VAO vao = new Context.VAO(context.GL_MAX_VERTEX_ATTRIBS);
                context.vaos.put(arrays[i], vao);
            }
        }
    }

    public static void glBindVertexArray(int index) {
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            Context.VAO vao = ctx.vaos.get(index);
            if (vao == null && ctx.shareGroup != null) {
                for (Context c : ctx.shareGroup.contexts) {
                    if (!c.vaos.containsKey(index)) continue;
                    RT.throwISEOrLogError("Trying to bind unknown VAO [" + index + "] from shared context [" + c.counter + "]");
                }
            }
            ctx.currentVao = vao;
        }
        org.lwjgl.opengl.ARBVertexArrayObject.glBindVertexArray(index);
    }

    public static void glDeleteVertexArrays(int index) {
        org.lwjgl.opengl.ARBVertexArrayObject.glDeleteVertexArrays(index);
        if (Properties.VALIDATE.enabled) {
            Context.deleteVertexArray(index);
        }
    }

    public static void glDeleteVertexArrays(IntBuffer indices) {
        org.lwjgl.opengl.ARBVertexArrayObject.glDeleteVertexArrays(indices);
        if (Properties.VALIDATE.enabled) {
            Context.deleteVertexArrays(indices);
        }
    }

    public static void glDeleteVertexArrays(int[] indices) {
        org.lwjgl.opengl.ARBVertexArrayObject.glDeleteVertexArrays(indices);
        if (Properties.VALIDATE.enabled) {
            Context.deleteVertexArrays(indices);
        }
    }
}

