/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.debug.GLmetadata;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.MethodCall;
import org.lwjglx.debug.Properties;

public class ARBShaderObjects {
    public static void glCompileShaderARB(int shader) {
        int status;
        org.lwjgl.opengl.ARBShaderObjects.glCompileShaderARB(shader);
        if (Properties.VALIDATE.enabled && (status = org.lwjgl.opengl.ARBShaderObjects.glGetObjectParameteriARB(shader, 35713)) != 1) {
            String shaderLog = org.lwjgl.opengl.ARBShaderObjects.glGetInfoLogARB(shader);
            Log.error("Shader [" + shader + "] did not compile successfully:\n" + shaderLog);
        }
    }

    public static void glLinkProgramARB(int program) {
        int status;
        org.lwjgl.opengl.ARBShaderObjects.glLinkProgramARB(program);
        if (Properties.VALIDATE.enabled && (status = org.lwjgl.opengl.ARBShaderObjects.glGetObjectParameteriARB(program, 35714)) != 1) {
            String programLog = org.lwjgl.opengl.ARBShaderObjects.glGetInfoLogARB(program);
            Log.error("Program [" + program + "] did not link successfully:\n" + programLog);
        }
    }

    public static void glShaderSource(int shader, PointerBuffer strings, IntBuffer length) {
        if (Properties.TRACE.enabled) {
            StringBuilder sb = new StringBuilder();
            if (strings != null && length != null) {
                int stringsPos = strings.position();
                int lengthPos = length.position();
                for (int i = 0; i < strings.remaining(); ++i) {
                    int len = length.get(lengthPos + i);
                    ByteBuffer string = MemoryUtil.memByteBuffer(strings.get(stringsPos + i), len);
                    String source = MemoryUtil.memASCII(string, len);
                    sb.append(source);
                }
            }
            Log.trace("Shader source for shader [" + shader + "]:\n" + sb.toString());
        }
        org.lwjgl.opengl.ARBShaderObjects.glShaderSourceARB(shader, strings, length);
    }

    public static void glShaderSource(int shader, CharSequence ... strings) {
        if (Properties.TRACE.enabled) {
            StringBuilder sb = new StringBuilder();
            if (strings != null) {
                for (int i = 0; i < strings.length; ++i) {
                    sb.append(strings[i]);
                }
            }
            Log.trace("Shader source for shader [" + shader + "]:\n" + sb.toString());
        }
        org.lwjgl.opengl.ARBShaderObjects.glShaderSourceARB(shader, strings);
    }

    public static void glShaderSource(int shader, CharSequence string) {
        if (Properties.TRACE.enabled) {
            Log.trace("Shader source for shader [" + shader + "]:\n" + string);
        }
        org.lwjgl.opengl.ARBShaderObjects.glShaderSourceARB(shader, string);
    }

    public static void glGetObjectParameteriARB(int shader, int pname, int ret, MethodCall mc) {
        mc.param(shader);
        mc.paramEnum(GLmetadata._null_().get(pname));
        switch (pname) {
            case 35713: {
                mc.returnValueEnum(GLmetadata.Boolean().get(ret));
                break;
            }
            case 35714: {
                mc.returnValueEnum(GLmetadata.Boolean().get(ret));
                break;
            }
            default: {
                mc.param(pname);
            }
        }
    }
}

