/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.ProfilingConnection;
import org.lwjglx.debug.ProfilingConnectionCreator;
import org.lwjglx.debug.javax.servlet.ServletException;
import org.lwjglx.debug.org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.lwjglx.debug.org.eclipse.jetty.server.HttpConnectionFactory;
import org.lwjglx.debug.org.eclipse.jetty.server.Server;
import org.lwjglx.debug.org.eclipse.jetty.server.ServerConnector;
import org.lwjglx.debug.org.eclipse.jetty.servlet.DefaultServlet;
import org.lwjglx.debug.org.eclipse.jetty.servlet.ServletContextHandler;
import org.lwjglx.debug.org.eclipse.jetty.servlet.ServletHolder;
import org.lwjglx.debug.org.eclipse.jetty.util.resource.Resource;
import org.lwjglx.debug.org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.lwjglx.debug.org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.lwjglx.debug.org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;
import org.lwjglx.debug.org.eclipse.jetty.websocket.servlet.WebSocketCreator;

class Profiling {
    public static final long sendIntervalMs = 500L;
    public static Server server;
    public static long lastSent;
    public static final CountDownLatch frontendConnected;

    Profiling() {
    }

    public static void startServer() throws ServletException {
        QueuedThreadPool threadPool = new QueuedThreadPool(10);
        threadPool.setDaemon(true);
        threadPool.setMaxThreads(10);
        Server server = new Server(threadPool);
        server.addBean((Object)new ScheduledExecutorScheduler("JettyScheduler", true), true);
        ServerConnector http = new ServerConnector(server, new HttpConnectionFactory());
        http.setPort(2992);
        server.addConnector(http);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.setBaseResource(Resource.newClassPathResource("/org/lwjglx/debug/static"));
        context.setWelcomeFiles(new String[]{"index.html"});
        server.setHandler(context);
        WebSocketUpgradeFilter wsfilter = WebSocketUpgradeFilter.configureContext(context);
        wsfilter.addMapping(new ServletPathSpec("/ws"), (WebSocketCreator)new ProfilingConnectionCreator());
        ServletHolder holderDefault = new ServletHolder("default", DefaultServlet.class);
        holderDefault.setInitParameter("dirAllowed", "true");
        context.addServlet(holderDefault, "/");
        try {
            server.start();
        }
        catch (Exception e) {
            throw new AssertionError("Could not start profiling server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void frame(Context ctx) {
        if (!ctx.firstFrameSeen) {
            ctx.firstFrameSeen = true;
            return;
        }
        if ((double)(ctx.frameEndTime - lastSent) / 1000000.0 < 500.0) {
            return;
        }
        lastSent = ctx.frameEndTime;
        ByteBuffer buf = MemoryUtil.memAlloc(1024).order(ByteOrder.BIG_ENDIAN);
        long addr = MemoryUtil.memAddress0(buf);
        float frameTimeCpu = (float)(ctx.frameEndTime - ctx.frameStartTime) / 1000000.0f;
        float drawCallTimeGpu = ctx.drawCallTimeMs;
        buf.putInt(ctx.counter);
        buf.putInt(ctx.frame);
        buf.putFloat(frameTimeCpu);
        buf.putFloat(drawCallTimeGpu);
        buf.putInt(ctx.glCallCount);
        buf.putInt(ctx.verticesCount);
        long boMemory = 0L;
        for (Context.BufferObject bo : ctx.bufferObjects.values()) {
            boMemory += bo.size;
        }
        buf.putDouble(boMemory / 1024L);
        long toMemory = 0L;
        for (Context.TextureObject to : ctx.textureObjects.values()) {
            if (to.layers == null) continue;
            for (Context.TextureLayer layer : to.layers) {
                if (layer.levels == null) continue;
                for (Context.TextureLevel level : layer.levels) {
                    toMemory += level.size;
                }
            }
        }
        buf.putDouble(toMemory / 1024L);
        buf.putShort((short)ctx.codeSectionTimes.size());
        for (Context.TimedCodeSection section : ctx.codeSectionTimes) {
            String name = section.name;
            byte[] nameBytes = name.getBytes();
            buf.putShort((short)nameBytes.length);
            for (int i = 0; i < nameBytes.length; ++i) {
                buf.put(nameBytes[i]);
            }
            float totalTime = 0.0f;
            for (Context.TimingQuery q : section.queries) {
                totalTime += (float)(q.time1 - q.time0) / 1000000.0f;
            }
            buf.putFloat(totalTime);
        }
        List<ProfilingConnection> list = ProfilingConnection.connections;
        synchronized (list) {
            for (ProfilingConnection c : ProfilingConnection.connections) {
                c.send(addr, buf.position());
            }
        }
        MemoryUtil.memFree(buf);
    }

    static {
        frontendConnected = new CountDownLatch(1);
    }
}

