/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.debug.Log;

public class MethodCall {
    private String source;
    private int line;
    private String name;
    private final List<String> params = new ArrayList<String>();
    private String returnValue;
    private boolean hasReturnValue;
    private String comment;

    public MethodCall(String source, int line, String name) {
        this.source = source;
        this.line = line;
        this.name = name;
    }

    public MethodCall param(int param) {
        this.params.add(Integer.toString(param));
        return this;
    }

    public MethodCall param(short param) {
        this.params.add(Short.toString(param));
        return this;
    }

    public MethodCall param(long param) {
        this.params.add(Long.toString(param) + "L");
        return this;
    }

    private static String removeUnicodeAndEscapeChars(String input) {
        StringBuilder buffer = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) > '\u0100') {
                buffer.append("\\u").append(Integer.toHexString(input.charAt(i)));
                continue;
            }
            if (input.charAt(i) == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (input.charAt(i) == '\t') {
                buffer.append("\\t");
                continue;
            }
            if (input.charAt(i) == '\r') {
                buffer.append("\\r");
                continue;
            }
            if (input.charAt(i) == '\b') {
                buffer.append("\\b");
                continue;
            }
            if (input.charAt(i) == '\f') {
                buffer.append("\\f");
                continue;
            }
            if (input.charAt(i) == '\"') {
                buffer.append("\\");
                continue;
            }
            if (input.charAt(i) == '\\') {
                buffer.append("\\\\");
                continue;
            }
            buffer.append(input.charAt(i));
        }
        return buffer.toString();
    }

    private String printBuffer(Buffer buffer) {
        String type = buffer instanceof ByteBuffer ? "ByteBuffer" : (buffer instanceof ShortBuffer ? "ShortBuffer" : (buffer instanceof IntBuffer ? "IntBuffer" : (buffer instanceof LongBuffer ? "LongBuffer" : (buffer instanceof CharBuffer ? "CharBuffer" : (buffer instanceof FloatBuffer ? "FloatBuffer" : (buffer instanceof DoubleBuffer ? "DoubleBuffer" : "<UNKNOWN>"))))));
        if (buffer.isDirect()) {
            long address = MemoryUtil.memAddress0(buffer);
            int pos = buffer.position();
            int lim = buffer.limit();
            int cap = buffer.capacity();
            if (pos == 0 && lim == cap) {
                return type + "[0x" + Long.toString(address, 16) + ", " + lim + "]";
            }
            return type + "[0x" + Long.toString(address, 16) + ", " + pos + ", " + lim + ", " + cap + "]";
        }
        int pos = buffer.position();
        int lim = buffer.limit();
        int cap = buffer.capacity();
        if (pos == 0 && lim == cap) {
            return type + "[ND, " + lim + "]";
        }
        return type + "[ND, " + pos + ", " + lim + ", " + cap + "]";
    }

    private String printBuffer(PointerBuffer buffer) {
        long address = MemoryUtil.memAddress0(buffer);
        int pos = buffer.position();
        int lim = buffer.limit();
        int cap = buffer.capacity();
        if (pos == 0 && lim == cap) {
            return "PointerBuffer[0x" + Long.toString(address, 16) + ", " + lim + "]";
        }
        return "PointerBuffer[0x" + Long.toString(address, 16) + ", " + pos + ", " + lim + ", " + cap + "]";
    }

    public MethodCall param(Object param) {
        if (param instanceof String) {
            String string = (String)param;
            this.params.add("\"" + MethodCall.removeUnicodeAndEscapeChars(string) + "\"");
        } else if (param instanceof Buffer) {
            Buffer buffer = (Buffer)param;
            this.params.add(this.printBuffer(buffer));
        } else if (param instanceof PointerBuffer) {
            PointerBuffer buffer = (PointerBuffer)param;
            this.printBuffer(buffer);
        } else {
            this.params.add(String.valueOf(param));
        }
        return this;
    }

    public MethodCall paramEnum(String param) {
        this.params.add(String.valueOf(param));
        return this;
    }

    public MethodCall param(boolean param) {
        this.params.add(Boolean.toString(param));
        return this;
    }

    public MethodCall param(char param) {
        if (param == '\'') {
            this.params.add("'\\" + param + "'");
        } else {
            this.params.add("'" + param + "'");
        }
        return this;
    }

    public MethodCall param(float param) {
        this.params.add(Float.toString(param) + "f");
        return this;
    }

    public MethodCall param(double param) {
        this.params.add(Double.toString(param));
        return this;
    }

    public int returnValue(int val) {
        this.returnValue = Integer.toString(val);
        this.hasReturnValue = true;
        return val;
    }

    public float returnValue(float val) {
        this.returnValue = Float.toString(val) + "f";
        this.hasReturnValue = true;
        return val;
    }

    public double returnValue(double val) {
        this.returnValue = Double.toString(val);
        this.hasReturnValue = true;
        return val;
    }

    public short returnValue(short val) {
        this.returnValue = Short.toString(val);
        this.hasReturnValue = true;
        return val;
    }

    public long returnValue(long val) {
        this.returnValue = Long.toString(val) + "L";
        this.hasReturnValue = true;
        return val;
    }

    public boolean returnValue(boolean val) {
        this.returnValue = Boolean.toString(val);
        this.hasReturnValue = true;
        return val;
    }

    public char returnValue(char val) {
        this.returnValue = val == '\'' ? "'\\" + val + "'" : "'" + val + "'";
        this.hasReturnValue = true;
        return val;
    }

    public Object returnValue(Object val) {
        if (val instanceof String) {
            String string = (String)val;
            this.returnValue = "\"" + MethodCall.removeUnicodeAndEscapeChars(string) + "\"";
        } else if (val instanceof Buffer) {
            Buffer buffer = (Buffer)val;
            this.returnValue = this.printBuffer(buffer);
        } else if (val instanceof PointerBuffer) {
            PointerBuffer buffer = (PointerBuffer)val;
            this.returnValue = this.printBuffer(buffer);
        } else {
            this.returnValue = String.valueOf(val);
        }
        this.hasReturnValue = true;
        return val;
    }

    public Object returnValueEnum(String val) {
        this.returnValue = val;
        this.hasReturnValue = true;
        return val;
    }

    public void comment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.source != null) {
            String sourceLine = "(" + this.source + ":" + this.line + ")";
            int pad = Log.maxSourceLength;
            pad += 3;
            sourceLine = String.format("%1$-" + (pad += Log.maxLineNumberLength) + "s", sourceLine);
            sb.append(sourceLine).append(" ");
        }
        sb.append(this.name).append("(");
        Iterator<String> it = this.params.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (this.hasReturnValue) {
            sb.append(" = ").append(String.valueOf(this.returnValue));
        }
        if (this.comment != null) {
            sb.append("  // ").append(this.comment);
        }
        return sb.toString();
    }
}

