/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Callback;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class Context
implements Comparable<Context> {
    public static final ThreadLocal<Context> CURRENT_CONTEXT = new ThreadLocal();
    public static final Map<Long, Context> CONTEXTS = new ConcurrentHashMap<Long, Context>();
    public static final Map<Long, ShareGroup> SHARE_GROUPS = new ConcurrentHashMap<Long, ShareGroup>();
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger(1);
    public GLCapabilities caps;
    public boolean inited;
    public int GL_MAX_VERTEX_ATTRIBS;
    public long window;
    public int counter;
    public Callback debugCallback;
    public VAO defaultVao;
    public VAO currentVao;
    public FBO defaultFbo;
    public FBO currentFbo;
    public ProgramPipeline defaultProgramPipeline;
    public ProgramPipeline currentProgramPipeline;
    public Map<Integer, VAO> vaos = new HashMap<Integer, VAO>();
    public Map<Integer, FBO> fbos = new HashMap<Integer, FBO>();
    public Map<Integer, BufferObject> bufferObjects = new HashMap<Integer, BufferObject>();
    public Map<Integer, BufferObject> bufferObjectBindings = new HashMap<Integer, BufferObject>();
    public Map<Integer, TextureObject> textureObjects = new HashMap<Integer, TextureObject>();
    public Map<Integer, TextureObject> textureObjectBindings = new HashMap<Integer, TextureObject>();
    public Map<Integer, ProgramPipeline> programPipelines = new HashMap<Integer, ProgramPipeline>();
    public ShareGroup shareGroup;
    public boolean inImmediateMode;
    public Thread currentInThread;
    public int verticesCount;
    public boolean drawCallSeen;
    public long frameStartTime;
    public long frameEndTime;
    public float drawCallTimeMs;
    public int glCallCount;
    public int immediateModeVertices;
    public int frame;
    public List<TimingQuery> timingQueries = new ArrayList<TimingQuery>(32);
    public TimingQuery currentTimingQuery;
    public boolean firstFrameSeen;
    public TimingQuery lastCodeSectionQuery;
    public int currentCodeSectionIndex = 0;
    public List<TimedCodeSection> codeSectionTimes = new ArrayList<TimedCodeSection>();

    public static void create(long window, long share) {
        Context ctx = new Context();
        ctx.window = window;
        ctx.counter = CONTEXT_COUNTER.getAndIncrement();
        if (share != 0L) {
            Context shareContext = CONTEXTS.get(share);
            ShareGroup shareGroup = SHARE_GROUPS.get(share);
            if (shareGroup == null) {
                shareGroup = new ShareGroup();
                shareGroup.contexts.add(shareContext);
                shareContext.shareGroup = shareGroup;
                SHARE_GROUPS.put(share, shareGroup);
            }
            ctx.shareGroup = shareGroup;
            SHARE_GROUPS.put(window, shareGroup);
            shareGroup.contexts.add(ctx);
        }
        CONTEXTS.put(window, ctx);
    }

    public String openglVersion() {
        String version = "1.1";
        if (this.caps.OpenGL12) {
            version = "1.2";
        }
        if (this.caps.OpenGL13) {
            version = "1.3";
        }
        if (this.caps.OpenGL14) {
            version = "1.4";
        }
        if (this.caps.OpenGL15) {
            version = "1.5";
        }
        if (this.caps.OpenGL20) {
            version = "2.0";
        }
        if (this.caps.OpenGL21) {
            version = "2.1";
        }
        if (this.caps.OpenGL30) {
            version = "3.0";
        }
        if (this.caps.OpenGL31) {
            version = "3.1";
        }
        if (this.caps.OpenGL32) {
            version = "3.2";
        }
        if (this.caps.OpenGL33) {
            version = "3.3";
        }
        if (this.caps.OpenGL40) {
            version = "4.0";
        }
        if (this.caps.OpenGL41) {
            version = "4.1";
        }
        if (this.caps.OpenGL42) {
            version = "4.2";
        }
        if (this.caps.OpenGL43) {
            version = "4.3";
        }
        if (this.caps.OpenGL44) {
            version = "4.4";
        }
        if (this.caps.OpenGL45) {
            version = "4.5";
        }
        return version;
    }

    public void init(int GL_MAX_VERTEX_ATTRIBS) {
        this.inited = true;
        this.GL_MAX_VERTEX_ATTRIBS = GL_MAX_VERTEX_ATTRIBS;
        this.currentVao = this.defaultVao = new VAO(GL_MAX_VERTEX_ATTRIBS);
        this.vaos.put(0, this.defaultVao);
        this.currentFbo = this.defaultFbo = new FBO(0);
        this.fbos.put(0, this.defaultFbo);
        this.currentProgramPipeline = this.defaultProgramPipeline = new ProgramPipeline();
        this.programPipelines.put(0, this.defaultProgramPipeline);
        StringBuilder sb = new StringBuilder();
        sb.append("Initialized OpenGL context for window[").append(this.counter).append("]\n");
        sb.append("  Effective OpenGL version: ").append(this.openglVersion()).append("\n");
        sb.append("  OpenGL version string   : ").append(GL11.glGetString(7938)).append("\n");
        sb.append("  OpenGL vendor           : ").append(GL11.glGetString(7936)).append("\n");
        sb.append("  OpenGL renderer         : ").append(GL11.glGetString(7937)).append("\n");
        sb.append("  GL_MAX_VERTEX_ATTRIBS   : ").append(GL_MAX_VERTEX_ATTRIBS).append("\n");
        Log.LineBreakingStringBuilder extensions = new Log.LineBreakingStringBuilder();
        for (Field field : GLCapabilities.class.getDeclaredFields()) {
            boolean isPublic = Modifier.isPublic(field.getModifiers());
            boolean isFinal = Modifier.isFinal(field.getModifiers());
            boolean isBoolean = field.getType() == Boolean.TYPE;
            boolean isOpenGL = field.getName().startsWith("OpenGL");
            if (!isPublic || !isFinal || !isBoolean || isOpenGL) continue;
            try {
                boolean supported = field.getBoolean(this.caps);
                if (!supported) continue;
                extensions.append(field.getName() + " ");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        sb.append("  Capabilities:\n    ").append(extensions.toString());
        Log.info(sb.toString(), 8);
    }

    public void destroy() {
        Log.info("Destroying OpenGL context for window[" + this.counter + "]");
        if (this.shareGroup != null) {
            this.shareGroup.contexts.remove(this);
            SHARE_GROUPS.remove(this.window);
            this.shareGroup = null;
        }
        if (this.debugCallback != null) {
            this.debugCallback.free();
        }
    }

    @Override
    public int compareTo(Context o) {
        if (this.window < o.window) {
            return -1;
        }
        if (this.window > o.window) {
            return 1;
        }
        return 0;
    }

    public TimingQuery nextTimerQuery() {
        for (int i = 0; i < this.timingQueries.size(); ++i) {
            TimingQuery qo = this.timingQueries.get(i);
            if (qo.used) continue;
            qo.used = true;
            qo.drawTime = false;
            return qo;
        }
        int before = ARBOcclusionQuery.glGenQueriesARB();
        int after = ARBOcclusionQuery.glGenQueriesARB();
        TimingQuery q = new TimingQuery();
        q.before = before;
        q.after = after;
        q.used = true;
        this.timingQueries.add(q);
        return q;
    }

    public static void deleteVertexArray(int index) {
        if (index == 0) {
            return;
        }
        Context context = CURRENT_CONTEXT.get();
        VAO vao = context.vaos.get(index);
        if (vao != null && vao == context.currentVao) {
            context.currentVao = context.defaultVao;
        }
        context.vaos.remove(index);
    }

    public static void deleteVertexArrays(IntBuffer indices) {
        Context context = CURRENT_CONTEXT.get();
        int pos = indices.position();
        for (int i = 0; i < indices.remaining(); ++i) {
            int index = indices.get(pos + i);
            if (index == 0) continue;
            VAO vao = context.vaos.get(index);
            if (vao != null && vao == context.currentVao) {
                context.currentVao = context.defaultVao;
            }
            context.vaos.remove(index);
        }
    }

    public static void deletePipeline(int index) {
        if (index == 0) {
            return;
        }
        Context context = CURRENT_CONTEXT.get();
        ProgramPipeline pp = context.programPipelines.get(index);
        if (pp != null && pp == context.currentProgramPipeline) {
            context.currentProgramPipeline = context.defaultProgramPipeline;
        }
        context.programPipelines.remove(index);
    }

    public static void deletePipelines(IntBuffer pipelines) {
        Context context = CURRENT_CONTEXT.get();
        int pos = pipelines.position();
        for (int i = 0; i < pipelines.remaining(); ++i) {
            int index = pipelines.get(pos + i);
            if (index == 0) continue;
            ProgramPipeline pp = context.programPipelines.get(index);
            if (pp != null && pp == context.currentProgramPipeline) {
                context.currentProgramPipeline = context.defaultProgramPipeline;
            }
            context.programPipelines.remove(index);
        }
    }

    public static void deletePipelines(int[] pipelines) {
        Context context = CURRENT_CONTEXT.get();
        for (int i = 0; i < pipelines.length; ++i) {
            int index = pipelines[i];
            if (index == 0) continue;
            ProgramPipeline pp = context.programPipelines.get(index);
            if (pp != null && pp == context.currentProgramPipeline) {
                context.currentProgramPipeline = context.defaultProgramPipeline;
            }
            context.programPipelines.remove(index);
        }
    }

    public static void deleteVertexArrays(int[] indices) {
        Context context = CURRENT_CONTEXT.get();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index == 0) continue;
            VAO vao = context.vaos.get(index);
            if (vao != null && vao == context.currentVao) {
                context.currentVao = context.defaultVao;
            }
            context.vaos.remove(index);
        }
    }

    public static void checkBeforeDrawCall() {
        Context.checkFramebufferCompleteness();
        Context.checkVertexAttributes();
    }

    public static void checkVertexAttributes() {
        Context context = CURRENT_CONTEXT.get();
        VAO vao = context.currentVao;
        for (int i = 0; i < vao.enabledVertexArrays.length; ++i) {
            if (!vao.enabledVertexArrays[i] || vao.initializedVertexArrays[i]) continue;
            RT.throwISEOrLogError("Vertex array [" + i + "] enabled but not initialized");
        }
        if (vao.vertexArrayEnabled && !vao.vertexArrayInitialized) {
            RT.throwISEOrLogError("GL_VERTEX_ARRAY enabled but not initialized");
        }
        if (vao.normalArrayEnabled && !vao.normalArrayInitialized) {
            RT.throwISEOrLogError("GL_NORMAL_ARRAY enabled but not initialized");
        }
        if (vao.colorArrayEnabled && !vao.colorArrayInitialized) {
            RT.throwISEOrLogError("GL_COLOR_ARRAY enabled but not initialized");
        }
        if (vao.texCoordArrayEnabled && !vao.texCoordArrayInitialized) {
            RT.throwISEOrLogError("GL_TEXTURE_COORD_ARRAY enabled but not initialized");
        }
    }

    public static void checkFramebufferCompleteness() {
        if (Properties.VALIDATE.enabled) {
            int status;
            Context context = CURRENT_CONTEXT.get();
            if (context.currentFbo != null && (status = GL30.glCheckFramebufferStatus(36160)) != 36053) {
                RT.throwISEOrLogError("Framebuffer [" + context.currentFbo.handle + "] is not complete: " + status);
            }
        }
    }

    public static class TimedCodeSection {
        public List<TimingQuery> queries = new ArrayList<TimingQuery>();
        public String name;
    }

    public static class TimingQuery {
        public int before;
        public int after;
        public long time0;
        public long time1;
        public boolean used;
        public boolean drawTime;
    }

    public static class TextureObject {
        public TextureLayer[] layers;
    }

    public static class TextureLayer {
        public TextureLevel[] levels;

        public void ensureLevel(int level) {
            if (this.levels == null) {
                this.levels = new TextureLevel[level + 1];
            } else if (this.levels.length <= level) {
                TextureLevel[] newLevels = new TextureLevel[level + 1];
                System.arraycopy(this.levels, 0, newLevels, 0, this.levels.length);
                this.levels = newLevels;
            }
            for (int i = 0; i < this.levels.length; ++i) {
                if (this.levels[i] != null) continue;
                this.levels[i] = new TextureLevel();
            }
        }
    }

    public static class TextureLevel {
        public long size;
        public int internalformat;
        public int width;
        public int height;
    }

    public static class BufferObject {
        public long size;
    }

    public static class ProgramPipeline {
    }

    public static class FBO {
        public int handle;

        public FBO(int handle) {
            this.handle = handle;
        }
    }

    public static class VAO {
        public boolean[] enabledVertexArrays;
        public boolean[] initializedVertexArrays;
        public boolean vertexArrayEnabled;
        public boolean vertexArrayInitialized;
        public boolean normalArrayEnabled;
        public boolean normalArrayInitialized;
        public boolean colorArrayEnabled;
        public boolean colorArrayInitialized;
        public boolean texCoordArrayEnabled;
        public boolean texCoordArrayInitialized;

        public VAO(int GL_MAX_VERTEX_ATTRIBS) {
            this.enabledVertexArrays = new boolean[GL_MAX_VERTEX_ATTRIBS];
            this.initializedVertexArrays = new boolean[GL_MAX_VERTEX_ATTRIBS];
        }
    }

    public static class ShareGroup {
        public Set<Context> contexts = new ConcurrentSkipListSet<Context>();
    }
}

