/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;

class ClassUtils {
    private static final MethodHandle defineClass;
    private static final MethodHandle lookupDefineClass;

    ClassUtils() {
    }

    static <T> Class<T> defineClass(ClassLoader cl, Class<?> hostClass, String name, byte[] definition) {
        if (lookupDefineClass != null) {
            try {
                return lookupDefineClass.invokeExact(MethodHandles.lookup().in(hostClass), definition);
            }
            catch (Throwable e) {
                throw new AssertionError("Could not define class", e);
            }
        }
        String apiName = name.replace('/', '.');
        try {
            return defineClass.invokeExact(cl, apiName, definition, 0, definition.length);
        }
        catch (Throwable e) {
            throw new AssertionError("Could not define class in JVM: " + name, e);
        }
    }

    static {
        MethodHandle lookupDefineClassMH = null;
        try {
            Method lookupDefineClassMethod = MethodHandles.Lookup.class.getDeclaredMethod("defineClass", byte[].class);
            lookupDefineClassMH = MethodHandles.lookup().unreflect(lookupDefineClassMethod);
        }
        catch (NoSuchMethodException lookupDefineClassMethod) {
        }
        catch (IllegalAccessException lookupDefineClassMethod) {
            // empty catch block
        }
        lookupDefineClass = lookupDefineClassMH;
        if (lookupDefineClassMH == null) {
            try {
                Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClassMethod.setAccessible(true);
                defineClass = MethodHandles.lookup().unreflect(defineClassMethod);
            }
            catch (Exception e) {
                throw new AssertionError((Object)"Could not find method: ClassLoader.defineClass");
            }
        } else {
            defineClass = null;
        }
    }
}

