/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.lwjglx.debug.org.objectweb.asm.AnnotationVisitor;
import org.lwjglx.debug.org.objectweb.asm.ClassReader;
import org.lwjglx.debug.org.objectweb.asm.ClassVisitor;
import org.lwjglx.debug.org.objectweb.asm.Label;
import org.lwjglx.debug.org.objectweb.asm.MethodVisitor;
import org.lwjglx.debug.org.objectweb.asm.Opcodes;
import org.lwjglx.debug.org.objectweb.asm.Type;

class ClassMetadata
implements Opcodes {
    private static final String NativeType_Desc = "Lorg/lwjgl/system/NativeType;";
    private static final String jsr305_Nullable_Desc = "Ljavax/annotation/Nullable;";
    static final Map<String, ClassMetadata> meta = new HashMap<String, ClassMetadata>();
    static boolean nullableSupportChecked;
    static boolean hasNullables;
    final Map<String, MethodInfo> methods = new HashMap<String, MethodInfo>();

    ClassMetadata() {
    }

    static ClassMetadata create(String internalName, ClassLoader cl) {
        ClassReader cr;
        if (!nullableSupportChecked) {
            nullableSupportChecked = true;
            ClassMetadata.create("org/lwjgl/system/MemoryUtil", cl);
        }
        if (meta.containsKey(internalName)) {
            return meta.get(internalName);
        }
        final ClassMetadata m = new ClassMetadata();
        InputStream is = cl.getResourceAsStream(internalName + ".class");
        try {
            cr = new ClassReader(is);
        }
        catch (IOException e) {
            return null;
        }
        cr.accept(new ClassVisitor(393216){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                boolean isStatic;
                boolean isPublic = (access & 1) != 0;
                boolean bl = isStatic = (access & 8) != 0;
                if (!isPublic || !isStatic) {
                    return null;
                }
                final MethodInfo minfo = new MethodInfo();
                Type[] argumentTypes = Type.getArgumentTypes(desc);
                int numParamLocals = 0;
                for (Type t : argumentTypes) {
                    numParamLocals += t.getSize();
                }
                final int[] localToParamIndex = new int[numParamLocals];
                int paramLocal = 0;
                for (int param = 0; param < argumentTypes.length; ++param) {
                    localToParamIndex[paramLocal] = param;
                    paramLocal += argumentTypes[param].getSize();
                }
                int numParameters = argumentTypes.length;
                minfo.parameterNativeTypes = new String[numParameters];
                minfo.nullable = new boolean[numParameters];
                minfo.parameterNames = new String[numParameters];
                minfo.name = name;
                m.methods.put(name + desc, minfo);
                return new MethodVisitor(393216){

                    @Override
                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        if (index >= localToParamIndex.length) {
                            return;
                        }
                        int param = localToParamIndex[index];
                        minfo.parameterNames[param] = name;
                    }

                    @Override
                    public AnnotationVisitor visitParameterAnnotation(final int parameter, String annotDesc, boolean visible) {
                        if (ClassMetadata.jsr305_Nullable_Desc.equals(annotDesc)) {
                            minfo.nullable[parameter] = true;
                            hasNullables = true;
                        } else if (ClassMetadata.NativeType_Desc.equals(annotDesc)) {
                            return new AnnotationVisitor(393216){

                                @Override
                                public void visit(String name, Object value) {
                                    if (!"value".equals(name) || !(value instanceof String)) {
                                        return;
                                    }
                                    minfo.parameterNativeTypes[parameter] = (String)value;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (!desc.equals(ClassMetadata.NativeType_Desc)) {
                            return null;
                        }
                        return new AnnotationVisitor(393216){

                            @Override
                            public void visit(String name, Object value) {
                                if (!"value".equals(name) || !(value instanceof String)) {
                                    return;
                                }
                                minfo.returnNativeType = (String)value;
                            }
                        };
                    }
                };
            }
        }, 4);
        meta.put(internalName, m);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return m;
    }

    static class MethodInfo {
        public String[] parameterNativeTypes;
        public String[] parameterNames;
        public boolean[] nullable;
        public String returnNativeType;
        public String name;

        MethodInfo() {
        }
    }
}

