/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.lwjglx.debug.InterceptClassGenerator;
import org.lwjglx.debug.InterceptedCall;
import org.lwjglx.debug.LWJGLInit;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.Profiling;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;
import org.lwjglx.debug.Util;
import org.lwjglx.debug.javax.servlet.ServletException;
import org.lwjglx.debug.joptsimple.ArgumentAcceptingOptionSpec;
import org.lwjglx.debug.joptsimple.OptionParser;
import org.lwjglx.debug.joptsimple.OptionSet;
import org.lwjglx.debug.org.objectweb.asm.ClassReader;
import org.lwjglx.debug.org.objectweb.asm.ClassVisitor;
import org.lwjglx.debug.org.objectweb.asm.ClassWriter;
import org.lwjglx.debug.org.objectweb.asm.Label;
import org.lwjglx.debug.org.objectweb.asm.MethodVisitor;
import org.lwjglx.debug.org.objectweb.asm.Opcodes;
import org.lwjglx.debug.org.objectweb.asm.util.TraceClassVisitor;

public class Agent
implements ClassFileTransformer,
Opcodes {
    private static final String RT_InternalName = "org/lwjglx/debug/RT";
    private static final AtomicInteger counter = new AtomicInteger();
    private final Set<Pattern> excludes;

    private Agent(Set<Pattern> excludes) {
        this.excludes = excludes;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            return this.transform_(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalClassFormatException(t.getMessage());
        }
    }

    private boolean excluded(String owner, String name) {
        for (Pattern p : this.excludes) {
            if (!p.matcher(owner + "." + name).find()) continue;
            return true;
        }
        return false;
    }

    private String resolveOwner(String methodOwner, final String methodName, final String methodDesc) {
        final StringBuilder resolvedOwner = new StringBuilder();
        try {
            String nextOwner = methodOwner;
            do {
                ClassReader cr;
                if ((cr = new ClassReader(nextOwner.replace('/', '.'))).getSuperName() == null || cr.getSuperName().equals("java/lang/Object")) {
                    resolvedOwner.append(nextOwner);
                    break;
                }
                final ClassReader fcr = cr;
                cr.accept(new ClassVisitor(393216){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        if ((access & 8) != 0 && name.equals(methodName) && descriptor.equals(methodDesc)) {
                            resolvedOwner.append(fcr.getClassName());
                        }
                        return null;
                    }
                }, 7);
                nextOwner = cr.getSuperName();
            } while (resolvedOwner.length() == 0);
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Could not load class " + methodOwner));
        }
        return resolvedOwner.length() == 0 ? null : resolvedOwner.toString();
    }

    private byte[] transform_(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className == null || className.startsWith("java/") || className.startsWith("com/sun/") || className.startsWith("sun/") || className.startsWith("jdk/internal/") || className.startsWith("org/lwjgl/") || className.startsWith("org/joml/") || className.startsWith("org/lwjglx/debug/")) {
            return null;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(1);
        class BooleanHolder {
            boolean value;

            BooleanHolder() {
            }
        }
        final BooleanHolder modified = new BooleanHolder();
        final LinkedHashMap calls = new LinkedHashMap();
        String callerName = className.replace('.', '/');
        final String proxyName = "org/lwjglx/debug/$Proxy$" + counter.incrementAndGet();
        class StringHolder {
            String value;

            StringHolder() {
            }
        }
        final StringHolder sourceFile = new StringHolder();
        ClassVisitor cv = new ClassVisitor(393216, cw){
            {
                super(x0, x1);
            }

            @Override
            public void visitSource(String source, String debug) {
                super.visitSource(source, debug);
                sourceFile.value = source;
                Log.maxSourceLength = Math.max(Log.maxSourceLength, source.length());
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(393216, mv){
                    private int lastLineNumber;
                    {
                        this.lastLineNumber = -1;
                    }

                    @Override
                    public void visitLineNumber(int line, Label start) {
                        super.visitLineNumber(line, start);
                        this.lastLineNumber = line;
                    }

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (Properties.PROFILE.enabled && opcode == 180 && owner.equals("org/lwjgl/opengl/GLCapabilities") && desc.equals("Z") && (name.equals("GL_GREMEDY_string_marker") || name.equals("GL_GREMEDY_frame_terminator"))) {
                            this.mv.visitInsn(87);
                            this.mv.visitInsn(4);
                            modified.value = true;
                            return;
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (opcode == 184 && owner.startsWith("org/lwjgl/") && !Agent.this.excluded(owner, name)) {
                            String key = owner + "." + name + desc;
                            InterceptedCall call = (InterceptedCall)calls.get(key);
                            if (call == null) {
                                String methodName;
                                String resolvedOwner = Agent.this.resolveOwner(owner, name, desc);
                                call = new InterceptedCall(owner, resolvedOwner, name, desc);
                                call.generatedMethodName = methodName = name + call.index;
                                calls.put(key, call);
                            }
                            Log.maxLineNumberLength = Math.max(Log.maxLineNumberLength, (int)(Math.log10(this.lastLineNumber) + 1.0));
                            String proxyDesc = call.desc;
                            if (Properties.TRACE.enabled) {
                                Util.ldcI(this.mv, this.lastLineNumber);
                                proxyDesc = call.desc.substring(0, call.desc.lastIndexOf(41)) + "I" + call.desc.substring(call.desc.lastIndexOf(41));
                            }
                            this.mv.visitMethodInsn(184, proxyName, call.generatedMethodName, proxyDesc, itf);
                            modified.value = true;
                        } else if (opcode == 182 && Util.isBuffer(owner) && Util.isMultiByteWrite(owner, name)) {
                            this.mv.visitMethodInsn(184, Agent.RT_InternalName, name, "(L" + owner + ";" + desc.substring(1), itf);
                            modified.value = true;
                        } else if (opcode == 182 && owner.equals("java/nio/ByteBuffer") && Util.isTypedViewMethod(name)) {
                            this.mv.visitMethodInsn(184, Agent.RT_InternalName, name, "(L" + owner + ";" + desc.substring(1), itf);
                            modified.value = true;
                        } else if (opcode == 182 && Util.isBuffer(owner) && name.equals("slice")) {
                            this.mv.visitMethodInsn(184, Agent.RT_InternalName, name, "(L" + owner + ";" + desc.substring(1), itf);
                            modified.value = true;
                        } else if (opcode == 182 && Util.isBuffer(owner) && name.equals("flip")) {
                            this.mv.visitInsn(89);
                            this.mv.visitMethodInsn(184, Agent.RT_InternalName, "checkFlipBufferAtPosition0", "(Ljava/nio/Buffer;)V", false);
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                            modified.value = true;
                        } else {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    }
                };
            }
        };
        cr.accept(cv, 0);
        if (!modified.value) {
            if (Properties.DEBUG.enabled) {
                Log.debug("Did not modify: " + className);
            }
            return null;
        }
        if (Properties.DEBUG.enabled) {
            Log.debug("Modified [" + className + "] (" + calls.size() + " calls into LWJGL)");
        }
        InterceptClassGenerator.generate(loader, proxyName, callerName, calls.values(), sourceFile.value);
        byte[] arr = cw.toByteArray();
        if (Properties.DEBUG.enabled) {
            TraceClassVisitor tcv = new TraceClassVisitor(new PrintWriter(System.err));
            ClassReader tcr = new ClassReader(arr);
            tcr.accept(tcv, 0);
        }
        return arr;
    }

    private static String convertGlobToRegEx(String line) {
        line = line.trim();
        int strLen = line.length();
        StringBuilder sb = new StringBuilder(strLen);
        if (!line.startsWith("*")) {
            sb.append("^");
        }
        if (line.endsWith("*")) {
            line = line.substring(0, strLen - 1);
            --strLen;
        }
        boolean escaping = false;
        int inCurlies = 0;
        block9: for (char currentChar : line.toCharArray()) {
            switch (currentChar) {
                case '*': {
                    if (escaping) {
                        sb.append("\\*");
                    } else {
                        sb.append(".*");
                    }
                    escaping = false;
                    continue block9;
                }
                case '?': {
                    if (escaping) {
                        sb.append("\\?");
                    } else {
                        sb.append('.');
                    }
                    escaping = false;
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(currentChar);
                    escaping = false;
                    continue block9;
                }
                case '\\': {
                    if (escaping) {
                        sb.append("\\\\");
                        escaping = false;
                        continue block9;
                    }
                    escaping = true;
                    continue block9;
                }
                case '{': {
                    if (escaping) {
                        sb.append("\\{");
                    } else {
                        sb.append('(');
                        ++inCurlies;
                    }
                    escaping = false;
                    continue block9;
                }
                case '}': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append(')');
                        --inCurlies;
                    } else if (escaping) {
                        sb.append("\\}");
                    } else {
                        sb.append("}");
                    }
                    escaping = false;
                    continue block9;
                }
                case ',': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append('|');
                        continue block9;
                    }
                    if (escaping) {
                        sb.append("\\,");
                        continue block9;
                    }
                    sb.append(",");
                    continue block9;
                }
                default: {
                    escaping = false;
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        HashSet<Pattern> excludes = new HashSet<Pattern>();
        excludes.add(Pattern.compile(Agent.convertGlobToRegEx("org/lwjgl/system/*")));
        if (agentArguments != null) {
            String[] args = agentArguments.split(";");
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) continue;
                args[i] = "-" + args[i];
            }
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec<String> path = parser.accepts("exclude").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
            parser.accepts("debug");
            parser.accepts("trace");
            ArgumentAcceptingOptionSpec<String> profile = parser.accepts("profile").withOptionalArg().ofType(String.class);
            parser.accepts("nothrow");
            ArgumentAcceptingOptionSpec<String> validate = parser.accepts("validate").withOptionalArg().ofType(String.class);
            ArgumentAcceptingOptionSpec<Long> sleep = parser.accepts("sleep").withRequiredArg().ofType(Long.class);
            ArgumentAcceptingOptionSpec<String> output = parser.accepts("output").withRequiredArg().ofType(String.class);
            OptionSet options = parser.parse(args);
            if (options.has("exclude")) {
                List<String> excluded = options.valuesOf(path);
                for (String e : excluded) {
                    excludes.add(Pattern.compile(Agent.convertGlobToRegEx(e)));
                }
            }
            if (options.has("debug")) {
                Properties.DEBUG.enable();
            }
            if (options.has("trace")) {
                Properties.TRACE.enable();
            }
            if (options.has("profile")) {
                Properties.PROFILE.enable();
                Properties.VALIDATE.disableIfByDefault();
                String profileArgsString = options.valueOf(profile);
                if (profileArgsString != null) {
                    String[] profileArgsStrings = profileArgsString.split(";");
                    for (int i = 0; i < args.length; ++i) {
                        if (profileArgsStrings[i].startsWith("-")) continue;
                        profileArgsStrings[i] = "-" + profileArgsStrings[i];
                    }
                    OptionParser profileArgParser = new OptionParser();
                    profileArgParser.accepts("suspend");
                    OptionSet profileArgs = profileArgParser.parse(profileArgsStrings);
                    if (profileArgs.has("suspend")) {
                        Properties.PROFILE_SUSPEND.enable();
                    }
                }
            }
            if (options.has("validate")) {
                Properties.VALIDATE.enable();
                String validateArgsString = options.valueOf(validate);
                if ("s".equals(validateArgsString)) {
                    Properties.STRICT.enable();
                }
            }
            if (options.has("nothrow")) {
                Properties.NO_THROW_ON_ERROR.enable();
            }
            if (options.has("sleep")) {
                Properties.SLEEP = options.valueOf(sleep);
            }
            if (options.has("output")) {
                Properties.OUTPUT = options.valueOf(output);
            }
        }
        if (Properties.PROFILE.enabled) {
            try {
                Profiling.startServer();
            }
            catch (ServletException e) {
                throw new AssertionError("Could not start profiling server", e);
            }
        }
        LWJGLInit.init();
        Agent t = new Agent(excludes);
        instrumentation.addTransformer(t);
        RT.mainThread = Thread.currentThread();
        if (Properties.PROFILE_SUSPEND.enabled) {
            try {
                Log.info("Waiting for first profile frontend to connect...");
                Profiling.frontendConnected.await();
                Log.info("Profile frontend connected. Resuming application startup.");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

