/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkWaylandSurfaceCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DISPLAY;
    public static final int SURFACE;

    VkWaylandSurfaceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkWaylandSurfaceCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkWaylandSurfaceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkWaylandSurfaceCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkWaylandSurfaceCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkWaylandSurfaceCreateFlagsKHR")
    public int flags() {
        return VkWaylandSurfaceCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="struct wl_display *")
    public long display() {
        return VkWaylandSurfaceCreateInfoKHR.ndisplay(this.address());
    }

    @NativeType(value="struct wl_surface *")
    public long surface() {
        return VkWaylandSurfaceCreateInfoKHR.nsurface(this.address());
    }

    public VkWaylandSurfaceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkWaylandSurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkWaylandSurfaceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkWaylandSurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkWaylandSurfaceCreateInfoKHR flags(@NativeType(value="VkWaylandSurfaceCreateFlagsKHR") int value) {
        VkWaylandSurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkWaylandSurfaceCreateInfoKHR display(@NativeType(value="struct wl_display *") long value) {
        VkWaylandSurfaceCreateInfoKHR.ndisplay(this.address(), value);
        return this;
    }

    public VkWaylandSurfaceCreateInfoKHR surface(@NativeType(value="struct wl_surface *") long value) {
        VkWaylandSurfaceCreateInfoKHR.nsurface(this.address(), value);
        return this;
    }

    public VkWaylandSurfaceCreateInfoKHR set(int sType, long pNext, int flags, long display, long surface) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.display(display);
        this.surface(surface);
        return this;
    }

    public VkWaylandSurfaceCreateInfoKHR set(VkWaylandSurfaceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkWaylandSurfaceCreateInfoKHR malloc() {
        return VkWaylandSurfaceCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkWaylandSurfaceCreateInfoKHR calloc() {
        return VkWaylandSurfaceCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkWaylandSurfaceCreateInfoKHR create() {
        return new VkWaylandSurfaceCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkWaylandSurfaceCreateInfoKHR create(long address) {
        return new VkWaylandSurfaceCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkWaylandSurfaceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkWaylandSurfaceCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkWaylandSurfaceCreateInfoKHR.create(VkWaylandSurfaceCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkWaylandSurfaceCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkWaylandSurfaceCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkWaylandSurfaceCreateInfoKHR.create(address, capacity);
    }

    public static VkWaylandSurfaceCreateInfoKHR mallocStack() {
        return VkWaylandSurfaceCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkWaylandSurfaceCreateInfoKHR callocStack() {
        return VkWaylandSurfaceCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkWaylandSurfaceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkWaylandSurfaceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkWaylandSurfaceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkWaylandSurfaceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkWaylandSurfaceCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkWaylandSurfaceCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkWaylandSurfaceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkWaylandSurfaceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DISPLAY);
    }

    public static long nsurface(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SURFACE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndisplay(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DISPLAY, Checks.check(value));
    }

    public static void nsurface(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SURFACE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DISPLAY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SURFACE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkWaylandSurfaceCreateInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkWaylandSurfaceCreateInfoKHR.__struct(VkWaylandSurfaceCreateInfoKHR.__member(4), VkWaylandSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkWaylandSurfaceCreateInfoKHR.__member(4), VkWaylandSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkWaylandSurfaceCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DISPLAY = layout.offsetof(3);
        SURFACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkWaylandSurfaceCreateInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkWaylandSurfaceCreateInfoKHR newInstance(long address) {
            return new VkWaylandSurfaceCreateInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkWaylandSurfaceCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkWaylandSurfaceCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkWaylandSurfaceCreateFlagsKHR")
        public int flags() {
            return VkWaylandSurfaceCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="struct wl_display *")
        public long display() {
            return VkWaylandSurfaceCreateInfoKHR.ndisplay(this.address());
        }

        @NativeType(value="struct wl_surface *")
        public long surface() {
            return VkWaylandSurfaceCreateInfoKHR.nsurface(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkWaylandSurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkWaylandSurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkWaylandSurfaceCreateFlagsKHR") int value) {
            VkWaylandSurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer display(@NativeType(value="struct wl_display *") long value) {
            VkWaylandSurfaceCreateInfoKHR.ndisplay(this.address(), value);
            return this;
        }

        public Buffer surface(@NativeType(value="struct wl_surface *") long value) {
            VkWaylandSurfaceCreateInfoKHR.nsurface(this.address(), value);
            return this;
        }
    }
}

