/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewportWScalingNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XCOEFF;
    public static final int YCOEFF;

    VkViewportWScalingNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkViewportWScalingNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkViewportWScalingNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float xcoeff() {
        return VkViewportWScalingNV.nxcoeff(this.address());
    }

    public float ycoeff() {
        return VkViewportWScalingNV.nycoeff(this.address());
    }

    public VkViewportWScalingNV xcoeff(float value) {
        VkViewportWScalingNV.nxcoeff(this.address(), value);
        return this;
    }

    public VkViewportWScalingNV ycoeff(float value) {
        VkViewportWScalingNV.nycoeff(this.address(), value);
        return this;
    }

    public VkViewportWScalingNV set(float xcoeff, float ycoeff) {
        this.xcoeff(xcoeff);
        this.ycoeff(ycoeff);
        return this;
    }

    public VkViewportWScalingNV set(VkViewportWScalingNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkViewportWScalingNV malloc() {
        return VkViewportWScalingNV.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkViewportWScalingNV calloc() {
        return VkViewportWScalingNV.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkViewportWScalingNV create() {
        return new VkViewportWScalingNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkViewportWScalingNV create(long address) {
        return new VkViewportWScalingNV(address, null);
    }

    @Nullable
    public static VkViewportWScalingNV createSafe(long address) {
        return address == 0L ? null : VkViewportWScalingNV.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkViewportWScalingNV.create(VkViewportWScalingNV.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkViewportWScalingNV.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkViewportWScalingNV.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkViewportWScalingNV.create(address, capacity);
    }

    public static VkViewportWScalingNV mallocStack() {
        return VkViewportWScalingNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkViewportWScalingNV callocStack() {
        return VkViewportWScalingNV.callocStack(MemoryStack.stackGet());
    }

    public static VkViewportWScalingNV mallocStack(MemoryStack stack) {
        return VkViewportWScalingNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkViewportWScalingNV callocStack(MemoryStack stack) {
        return VkViewportWScalingNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkViewportWScalingNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkViewportWScalingNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewportWScalingNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewportWScalingNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nxcoeff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XCOEFF);
    }

    public static float nycoeff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YCOEFF);
    }

    public static void nxcoeff(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)XCOEFF, value);
    }

    public static void nycoeff(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)YCOEFF, value);
    }

    static {
        Struct.Layout layout = VkViewportWScalingNV.__struct(VkViewportWScalingNV.__member(4), VkViewportWScalingNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XCOEFF = layout.offsetof(0);
        YCOEFF = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkViewportWScalingNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkViewportWScalingNV newInstance(long address) {
            return new VkViewportWScalingNV(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float xcoeff() {
            return VkViewportWScalingNV.nxcoeff(this.address());
        }

        public float ycoeff() {
            return VkViewportWScalingNV.nycoeff(this.address());
        }

        public Buffer xcoeff(float value) {
            VkViewportWScalingNV.nxcoeff(this.address(), value);
            return this;
        }

        public Buffer ycoeff(float value) {
            VkViewportWScalingNV.nycoeff(this.address(), value);
            return this;
        }
    }
}

