/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassEndInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;

    VkSubpassEndInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSubpassEndInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubpassEndInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassEndInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassEndInfoKHR.npNext(this.address());
    }

    public VkSubpassEndInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassEndInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkSubpassEndInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassEndInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkSubpassEndInfoKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSubpassEndInfoKHR set(VkSubpassEndInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassEndInfoKHR malloc() {
        return VkSubpassEndInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassEndInfoKHR calloc() {
        return VkSubpassEndInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassEndInfoKHR create() {
        return new VkSubpassEndInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubpassEndInfoKHR create(long address) {
        return new VkSubpassEndInfoKHR(address, null);
    }

    @Nullable
    public static VkSubpassEndInfoKHR createSafe(long address) {
        return address == 0L ? null : VkSubpassEndInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassEndInfoKHR.create(VkSubpassEndInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassEndInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSubpassEndInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassEndInfoKHR.create(address, capacity);
    }

    public static VkSubpassEndInfoKHR mallocStack() {
        return VkSubpassEndInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassEndInfoKHR callocStack() {
        return VkSubpassEndInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassEndInfoKHR mallocStack(MemoryStack stack) {
        return VkSubpassEndInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassEndInfoKHR callocStack(MemoryStack stack) {
        return VkSubpassEndInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassEndInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassEndInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkSubpassEndInfoKHR.__struct(VkSubpassEndInfoKHR.__member(4), VkSubpassEndInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassEndInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubpassEndInfoKHR newInstance(long address) {
            return new VkSubpassEndInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassEndInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassEndInfoKHR.npNext(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassEndInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassEndInfoKHR.npNext(this.address(), value);
            return this;
        }
    }
}

