/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassDependency2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCSUBPASS;
    public static final int DSTSUBPASS;
    public static final int SRCSTAGEMASK;
    public static final int DSTSTAGEMASK;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;
    public static final int DEPENDENCYFLAGS;
    public static final int VIEWOFFSET;

    VkSubpassDependency2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSubpassDependency2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubpassDependency2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassDependency2KHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassDependency2KHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcSubpass() {
        return VkSubpassDependency2KHR.nsrcSubpass(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstSubpass() {
        return VkSubpassDependency2KHR.ndstSubpass(this.address());
    }

    @NativeType(value="VkPipelineStageFlags")
    public int srcStageMask() {
        return VkSubpassDependency2KHR.nsrcStageMask(this.address());
    }

    @NativeType(value="VkPipelineStageFlags")
    public int dstStageMask() {
        return VkSubpassDependency2KHR.ndstStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int srcAccessMask() {
        return VkSubpassDependency2KHR.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int dstAccessMask() {
        return VkSubpassDependency2KHR.ndstAccessMask(this.address());
    }

    @NativeType(value="VkDependencyFlags")
    public int dependencyFlags() {
        return VkSubpassDependency2KHR.ndependencyFlags(this.address());
    }

    @NativeType(value="int32_t")
    public int viewOffset() {
        return VkSubpassDependency2KHR.nviewOffset(this.address());
    }

    public VkSubpassDependency2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassDependency2KHR.nsType(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassDependency2KHR.npNext(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR srcSubpass(@NativeType(value="uint32_t") int value) {
        VkSubpassDependency2KHR.nsrcSubpass(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR dstSubpass(@NativeType(value="uint32_t") int value) {
        VkSubpassDependency2KHR.ndstSubpass(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR srcStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
        VkSubpassDependency2KHR.nsrcStageMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR dstStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
        VkSubpassDependency2KHR.ndstStageMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkSubpassDependency2KHR.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkSubpassDependency2KHR.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
        VkSubpassDependency2KHR.ndependencyFlags(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR viewOffset(@NativeType(value="int32_t") int value) {
        VkSubpassDependency2KHR.nviewOffset(this.address(), value);
        return this;
    }

    public VkSubpassDependency2KHR set(int sType, long pNext, int srcSubpass, int dstSubpass, int srcStageMask, int dstStageMask, int srcAccessMask, int dstAccessMask, int dependencyFlags, int viewOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcSubpass(srcSubpass);
        this.dstSubpass(dstSubpass);
        this.srcStageMask(srcStageMask);
        this.dstStageMask(dstStageMask);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        this.dependencyFlags(dependencyFlags);
        this.viewOffset(viewOffset);
        return this;
    }

    public VkSubpassDependency2KHR set(VkSubpassDependency2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassDependency2KHR malloc() {
        return VkSubpassDependency2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassDependency2KHR calloc() {
        return VkSubpassDependency2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassDependency2KHR create() {
        return new VkSubpassDependency2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubpassDependency2KHR create(long address) {
        return new VkSubpassDependency2KHR(address, null);
    }

    @Nullable
    public static VkSubpassDependency2KHR createSafe(long address) {
        return address == 0L ? null : VkSubpassDependency2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassDependency2KHR.create(VkSubpassDependency2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassDependency2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSubpassDependency2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassDependency2KHR.create(address, capacity);
    }

    public static VkSubpassDependency2KHR mallocStack() {
        return VkSubpassDependency2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDependency2KHR callocStack() {
        return VkSubpassDependency2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDependency2KHR mallocStack(MemoryStack stack) {
        return VkSubpassDependency2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassDependency2KHR callocStack(MemoryStack stack) {
        return VkSubpassDependency2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassDependency2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassDependency2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassDependency2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassDependency2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsrcSubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCSUBPASS);
    }

    public static int ndstSubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTSUBPASS);
    }

    public static int nsrcStageMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCSTAGEMASK);
    }

    public static int ndstStageMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTSTAGEMASK);
    }

    public static int nsrcAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTACCESSMASK);
    }

    public static int ndependencyFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPENDENCYFLAGS);
    }

    public static int nviewOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWOFFSET);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcSubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCSUBPASS, value);
    }

    public static void ndstSubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTSUBPASS, value);
    }

    public static void nsrcStageMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCSTAGEMASK, value);
    }

    public static void ndstStageMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTSTAGEMASK, value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTACCESSMASK, value);
    }

    public static void ndependencyFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPENDENCYFLAGS, value);
    }

    public static void nviewOffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWOFFSET, value);
    }

    static {
        Struct.Layout layout = VkSubpassDependency2KHR.__struct(VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(POINTER_SIZE), VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(4), VkSubpassDependency2KHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCSUBPASS = layout.offsetof(2);
        DSTSUBPASS = layout.offsetof(3);
        SRCSTAGEMASK = layout.offsetof(4);
        DSTSTAGEMASK = layout.offsetof(5);
        SRCACCESSMASK = layout.offsetof(6);
        DSTACCESSMASK = layout.offsetof(7);
        DEPENDENCYFLAGS = layout.offsetof(8);
        VIEWOFFSET = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassDependency2KHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubpassDependency2KHR newInstance(long address) {
            return new VkSubpassDependency2KHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassDependency2KHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassDependency2KHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcSubpass() {
            return VkSubpassDependency2KHR.nsrcSubpass(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstSubpass() {
            return VkSubpassDependency2KHR.ndstSubpass(this.address());
        }

        @NativeType(value="VkPipelineStageFlags")
        public int srcStageMask() {
            return VkSubpassDependency2KHR.nsrcStageMask(this.address());
        }

        @NativeType(value="VkPipelineStageFlags")
        public int dstStageMask() {
            return VkSubpassDependency2KHR.ndstStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int srcAccessMask() {
            return VkSubpassDependency2KHR.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int dstAccessMask() {
            return VkSubpassDependency2KHR.ndstAccessMask(this.address());
        }

        @NativeType(value="VkDependencyFlags")
        public int dependencyFlags() {
            return VkSubpassDependency2KHR.ndependencyFlags(this.address());
        }

        @NativeType(value="int32_t")
        public int viewOffset() {
            return VkSubpassDependency2KHR.nviewOffset(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassDependency2KHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassDependency2KHR.npNext(this.address(), value);
            return this;
        }

        public Buffer srcSubpass(@NativeType(value="uint32_t") int value) {
            VkSubpassDependency2KHR.nsrcSubpass(this.address(), value);
            return this;
        }

        public Buffer dstSubpass(@NativeType(value="uint32_t") int value) {
            VkSubpassDependency2KHR.ndstSubpass(this.address(), value);
            return this;
        }

        public Buffer srcStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
            VkSubpassDependency2KHR.nsrcStageMask(this.address(), value);
            return this;
        }

        public Buffer dstStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
            VkSubpassDependency2KHR.ndstStageMask(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkSubpassDependency2KHR.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkSubpassDependency2KHR.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
            VkSubpassDependency2KHR.ndependencyFlags(this.address(), value);
            return this;
        }

        public Buffer viewOffset(@NativeType(value="int32_t") int value) {
            VkSubpassDependency2KHR.nviewOffset(this.address(), value);
            return this;
        }
    }
}

