/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassDependency
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCSUBPASS;
    public static final int DSTSUBPASS;
    public static final int SRCSTAGEMASK;
    public static final int DSTSTAGEMASK;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;
    public static final int DEPENDENCYFLAGS;

    VkSubpassDependency(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSubpassDependency(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubpassDependency.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int srcSubpass() {
        return VkSubpassDependency.nsrcSubpass(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstSubpass() {
        return VkSubpassDependency.ndstSubpass(this.address());
    }

    @NativeType(value="VkPipelineStageFlags")
    public int srcStageMask() {
        return VkSubpassDependency.nsrcStageMask(this.address());
    }

    @NativeType(value="VkPipelineStageFlags")
    public int dstStageMask() {
        return VkSubpassDependency.ndstStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int srcAccessMask() {
        return VkSubpassDependency.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int dstAccessMask() {
        return VkSubpassDependency.ndstAccessMask(this.address());
    }

    @NativeType(value="VkDependencyFlags")
    public int dependencyFlags() {
        return VkSubpassDependency.ndependencyFlags(this.address());
    }

    public VkSubpassDependency srcSubpass(@NativeType(value="uint32_t") int value) {
        VkSubpassDependency.nsrcSubpass(this.address(), value);
        return this;
    }

    public VkSubpassDependency dstSubpass(@NativeType(value="uint32_t") int value) {
        VkSubpassDependency.ndstSubpass(this.address(), value);
        return this;
    }

    public VkSubpassDependency srcStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
        VkSubpassDependency.nsrcStageMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency dstStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
        VkSubpassDependency.ndstStageMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkSubpassDependency.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkSubpassDependency.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkSubpassDependency dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
        VkSubpassDependency.ndependencyFlags(this.address(), value);
        return this;
    }

    public VkSubpassDependency set(int srcSubpass, int dstSubpass, int srcStageMask, int dstStageMask, int srcAccessMask, int dstAccessMask, int dependencyFlags) {
        this.srcSubpass(srcSubpass);
        this.dstSubpass(dstSubpass);
        this.srcStageMask(srcStageMask);
        this.dstStageMask(dstStageMask);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        this.dependencyFlags(dependencyFlags);
        return this;
    }

    public VkSubpassDependency set(VkSubpassDependency src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassDependency malloc() {
        return VkSubpassDependency.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassDependency calloc() {
        return VkSubpassDependency.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassDependency create() {
        return new VkSubpassDependency(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubpassDependency create(long address) {
        return new VkSubpassDependency(address, null);
    }

    @Nullable
    public static VkSubpassDependency createSafe(long address) {
        return address == 0L ? null : VkSubpassDependency.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassDependency.create(VkSubpassDependency.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassDependency.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSubpassDependency.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassDependency.create(address, capacity);
    }

    public static VkSubpassDependency mallocStack() {
        return VkSubpassDependency.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDependency callocStack() {
        return VkSubpassDependency.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDependency mallocStack(MemoryStack stack) {
        return VkSubpassDependency.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassDependency callocStack(MemoryStack stack) {
        return VkSubpassDependency.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassDependency.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassDependency.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassDependency.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassDependency.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsrcSubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCSUBPASS);
    }

    public static int ndstSubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTSUBPASS);
    }

    public static int nsrcStageMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCSTAGEMASK);
    }

    public static int ndstStageMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTSTAGEMASK);
    }

    public static int nsrcAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTACCESSMASK);
    }

    public static int ndependencyFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPENDENCYFLAGS);
    }

    public static void nsrcSubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCSUBPASS, value);
    }

    public static void ndstSubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTSUBPASS, value);
    }

    public static void nsrcStageMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCSTAGEMASK, value);
    }

    public static void ndstStageMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTSTAGEMASK, value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTACCESSMASK, value);
    }

    public static void ndependencyFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPENDENCYFLAGS, value);
    }

    static {
        Struct.Layout layout = VkSubpassDependency.__struct(VkSubpassDependency.__member(4), VkSubpassDependency.__member(4), VkSubpassDependency.__member(4), VkSubpassDependency.__member(4), VkSubpassDependency.__member(4), VkSubpassDependency.__member(4), VkSubpassDependency.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCSUBPASS = layout.offsetof(0);
        DSTSUBPASS = layout.offsetof(1);
        SRCSTAGEMASK = layout.offsetof(2);
        DSTSTAGEMASK = layout.offsetof(3);
        SRCACCESSMASK = layout.offsetof(4);
        DSTACCESSMASK = layout.offsetof(5);
        DEPENDENCYFLAGS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassDependency, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubpassDependency newInstance(long address) {
            return new VkSubpassDependency(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int srcSubpass() {
            return VkSubpassDependency.nsrcSubpass(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstSubpass() {
            return VkSubpassDependency.ndstSubpass(this.address());
        }

        @NativeType(value="VkPipelineStageFlags")
        public int srcStageMask() {
            return VkSubpassDependency.nsrcStageMask(this.address());
        }

        @NativeType(value="VkPipelineStageFlags")
        public int dstStageMask() {
            return VkSubpassDependency.ndstStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int srcAccessMask() {
            return VkSubpassDependency.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int dstAccessMask() {
            return VkSubpassDependency.ndstAccessMask(this.address());
        }

        @NativeType(value="VkDependencyFlags")
        public int dependencyFlags() {
            return VkSubpassDependency.ndependencyFlags(this.address());
        }

        public Buffer srcSubpass(@NativeType(value="uint32_t") int value) {
            VkSubpassDependency.nsrcSubpass(this.address(), value);
            return this;
        }

        public Buffer dstSubpass(@NativeType(value="uint32_t") int value) {
            VkSubpassDependency.ndstSubpass(this.address(), value);
            return this;
        }

        public Buffer srcStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
            VkSubpassDependency.nsrcStageMask(this.address(), value);
            return this;
        }

        public Buffer dstStageMask(@NativeType(value="VkPipelineStageFlags") int value) {
            VkSubpassDependency.ndstStageMask(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkSubpassDependency.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkSubpassDependency.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
            VkSubpassDependency.ndependencyFlags(this.address(), value);
            return this;
        }
    }
}

