/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseMemoryBind;

public class VkSparseImageOpaqueMemoryBindInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    VkSparseImageOpaqueMemoryBindInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSparseImageOpaqueMemoryBindInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseImageOpaqueMemoryBindInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkSparseImageOpaqueMemoryBindInfo.nimage(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindCount() {
        return VkSparseImageOpaqueMemoryBindInfo.nbindCount(this.address());
    }

    @NativeType(value="VkSparseMemoryBind const *")
    public VkSparseMemoryBind.Buffer pBinds() {
        return VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseImageOpaqueMemoryBindInfo image(@NativeType(value="VkImage") long value) {
        VkSparseImageOpaqueMemoryBindInfo.nimage(this.address(), value);
        return this;
    }

    public VkSparseImageOpaqueMemoryBindInfo pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
        VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseImageOpaqueMemoryBindInfo set(long image, VkSparseMemoryBind.Buffer pBinds) {
        this.image(image);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseImageOpaqueMemoryBindInfo set(VkSparseImageOpaqueMemoryBindInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseImageOpaqueMemoryBindInfo malloc() {
        return VkSparseImageOpaqueMemoryBindInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseImageOpaqueMemoryBindInfo calloc() {
        return VkSparseImageOpaqueMemoryBindInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseImageOpaqueMemoryBindInfo create() {
        return new VkSparseImageOpaqueMemoryBindInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseImageOpaqueMemoryBindInfo create(long address) {
        return new VkSparseImageOpaqueMemoryBindInfo(address, null);
    }

    @Nullable
    public static VkSparseImageOpaqueMemoryBindInfo createSafe(long address) {
        return address == 0L ? null : VkSparseImageOpaqueMemoryBindInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageOpaqueMemoryBindInfo.create(VkSparseImageOpaqueMemoryBindInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageOpaqueMemoryBindInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSparseImageOpaqueMemoryBindInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseImageOpaqueMemoryBindInfo.create(address, capacity);
    }

    public static VkSparseImageOpaqueMemoryBindInfo mallocStack() {
        return VkSparseImageOpaqueMemoryBindInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageOpaqueMemoryBindInfo callocStack() {
        return VkSparseImageOpaqueMemoryBindInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageOpaqueMemoryBindInfo mallocStack(MemoryStack stack) {
        return VkSparseImageOpaqueMemoryBindInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageOpaqueMemoryBindInfo callocStack(MemoryStack stack) {
        return VkSparseImageOpaqueMemoryBindInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageOpaqueMemoryBindInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageOpaqueMemoryBindInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageOpaqueMemoryBindInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageOpaqueMemoryBindInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static int nbindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDCOUNT);
    }

    public static VkSparseMemoryBind.Buffer npBinds(long struct) {
        return VkSparseMemoryBind.create(MemoryUtil.memGetAddress(struct + (long)PBINDS), VkSparseImageOpaqueMemoryBindInfo.nbindCount(struct));
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nbindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDS, value.address());
        VkSparseImageOpaqueMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PBINDS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSparseImageOpaqueMemoryBindInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSparseImageOpaqueMemoryBindInfo.__struct(VkSparseImageOpaqueMemoryBindInfo.__member(8), VkSparseImageOpaqueMemoryBindInfo.__member(4), VkSparseImageOpaqueMemoryBindInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageOpaqueMemoryBindInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseImageOpaqueMemoryBindInfo newInstance(long address) {
            return new VkSparseImageOpaqueMemoryBindInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkSparseImageOpaqueMemoryBindInfo.nimage(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindCount() {
            return VkSparseImageOpaqueMemoryBindInfo.nbindCount(this.address());
        }

        @NativeType(value="VkSparseMemoryBind const *")
        public VkSparseMemoryBind.Buffer pBinds() {
            return VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address());
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkSparseImageOpaqueMemoryBindInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
            VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

