/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkSparseImageMemoryRequirements2;

public class VkSparseImageMemoryRequirements2KHR
extends VkSparseImageMemoryRequirements2 {
    VkSparseImageMemoryRequirements2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSparseImageMemoryRequirements2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseImageMemoryRequirements2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkSparseImageMemoryRequirements2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkSparseImageMemoryRequirements2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkSparseImageMemoryRequirements2KHR pNext(@NativeType(value="void *") long value) {
        VkSparseImageMemoryRequirements2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkSparseImageMemoryRequirements2KHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSparseImageMemoryRequirements2KHR set(VkSparseImageMemoryRequirements2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseImageMemoryRequirements2KHR malloc() {
        return VkSparseImageMemoryRequirements2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2KHR calloc() {
        return VkSparseImageMemoryRequirements2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2KHR create() {
        return new VkSparseImageMemoryRequirements2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2KHR create(long address) {
        return new VkSparseImageMemoryRequirements2KHR(address, null);
    }

    @Nullable
    public static VkSparseImageMemoryRequirements2KHR createSafe(long address) {
        return address == 0L ? null : VkSparseImageMemoryRequirements2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageMemoryRequirements2KHR.create(VkSparseImageMemoryRequirements2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageMemoryRequirements2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSparseImageMemoryRequirements2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseImageMemoryRequirements2KHR.create(address, capacity);
    }

    public static VkSparseImageMemoryRequirements2KHR mallocStack() {
        return VkSparseImageMemoryRequirements2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryRequirements2KHR callocStack() {
        return VkSparseImageMemoryRequirements2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryRequirements2KHR mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2KHR callocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryRequirements2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryRequirements2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkSparseImageMemoryRequirements2.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseImageMemoryRequirements2KHR newInstance(long address) {
            return new VkSparseImageMemoryRequirements2KHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSparseImageMemoryRequirements2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkSparseImageMemoryRequirements2KHR.npNext(this.address(), value);
            return this;
        }
    }
}

