/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresource;
import org.lwjgl.vulkan.VkOffset3D;

public class VkSparseImageMemoryBind
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBRESOURCE;
    public static final int OFFSET;
    public static final int EXTENT;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int FLAGS;

    VkSparseImageMemoryBind(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSparseImageMemoryBind(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseImageMemoryBind.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresource subresource() {
        return VkSparseImageMemoryBind.nsubresource(this.address());
    }

    public VkSparseImageMemoryBind subresource(Consumer<VkImageSubresource> consumer) {
        consumer.accept(this.subresource());
        return this;
    }

    public VkOffset3D offset() {
        return VkSparseImageMemoryBind.noffset(this.address());
    }

    public VkSparseImageMemoryBind offset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public VkExtent3D extent() {
        return VkSparseImageMemoryBind.nextent(this.address());
    }

    public VkSparseImageMemoryBind extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkSparseImageMemoryBind.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkSparseImageMemoryBind.nmemoryOffset(this.address());
    }

    @NativeType(value="VkSparseMemoryBindFlags")
    public int flags() {
        return VkSparseImageMemoryBind.nflags(this.address());
    }

    public VkSparseImageMemoryBind subresource(VkImageSubresource value) {
        VkSparseImageMemoryBind.nsubresource(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind offset(VkOffset3D value) {
        VkSparseImageMemoryBind.noffset(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind extent(VkExtent3D value) {
        VkSparseImageMemoryBind.nextent(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind memory(@NativeType(value="VkDeviceMemory") long value) {
        VkSparseImageMemoryBind.nmemory(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkSparseImageMemoryBind.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
        VkSparseImageMemoryBind.nflags(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind set(VkImageSubresource subresource, VkOffset3D offset, VkExtent3D extent, long memory, long memoryOffset, int flags) {
        this.subresource(subresource);
        this.offset(offset);
        this.extent(extent);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.flags(flags);
        return this;
    }

    public VkSparseImageMemoryBind set(VkSparseImageMemoryBind src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseImageMemoryBind malloc() {
        return VkSparseImageMemoryBind.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseImageMemoryBind calloc() {
        return VkSparseImageMemoryBind.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseImageMemoryBind create() {
        return new VkSparseImageMemoryBind(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseImageMemoryBind create(long address) {
        return new VkSparseImageMemoryBind(address, null);
    }

    @Nullable
    public static VkSparseImageMemoryBind createSafe(long address) {
        return address == 0L ? null : VkSparseImageMemoryBind.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageMemoryBind.create(VkSparseImageMemoryBind.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageMemoryBind.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSparseImageMemoryBind.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseImageMemoryBind.create(address, capacity);
    }

    public static VkSparseImageMemoryBind mallocStack() {
        return VkSparseImageMemoryBind.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryBind callocStack() {
        return VkSparseImageMemoryBind.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryBind mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryBind.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryBind callocStack(MemoryStack stack) {
        return VkSparseImageMemoryBind.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryBind.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryBind.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBind.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBind.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageSubresource nsubresource(long struct) {
        return VkImageSubresource.create(struct + (long)SUBRESOURCE);
    }

    public static VkOffset3D noffset(long struct) {
        return VkOffset3D.create(struct + (long)OFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORYOFFSET);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nsubresource(long struct, VkImageSubresource value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBRESOURCE, VkImageSubresource.SIZEOF);
    }

    public static void noffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent3D.SIZEOF);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORYOFFSET, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryBind.__struct(VkSparseImageMemoryBind.__member(VkImageSubresource.SIZEOF, VkImageSubresource.ALIGNOF), VkSparseImageMemoryBind.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkSparseImageMemoryBind.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF), VkSparseImageMemoryBind.__member(8), VkSparseImageMemoryBind.__member(8), VkSparseImageMemoryBind.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBRESOURCE = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        EXTENT = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryBind, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseImageMemoryBind newInstance(long address) {
            return new VkSparseImageMemoryBind(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public VkImageSubresource subresource() {
            return VkSparseImageMemoryBind.nsubresource(this.address());
        }

        public Buffer subresource(Consumer<VkImageSubresource> consumer) {
            consumer.accept(this.subresource());
            return this;
        }

        public VkOffset3D offset() {
            return VkSparseImageMemoryBind.noffset(this.address());
        }

        public Buffer offset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public VkExtent3D extent() {
            return VkSparseImageMemoryBind.nextent(this.address());
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkSparseImageMemoryBind.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkSparseImageMemoryBind.nmemoryOffset(this.address());
        }

        @NativeType(value="VkSparseMemoryBindFlags")
        public int flags() {
            return VkSparseImageMemoryBind.nflags(this.address());
        }

        public Buffer subresource(VkImageSubresource value) {
            VkSparseImageMemoryBind.nsubresource(this.address(), value);
            return this;
        }

        public Buffer offset(VkOffset3D value) {
            VkSparseImageMemoryBind.noffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkSparseImageMemoryBind.nextent(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkSparseImageMemoryBind.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkSparseImageMemoryBind.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
            VkSparseImageMemoryBind.nflags(this.address(), value);
            return this;
        }
    }
}

