/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkShaderResourceUsageAMD
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUMUSEDVGPRS;
    public static final int NUMUSEDSGPRS;
    public static final int LDSSIZEPERLOCALWORKGROUP;
    public static final int LDSUSAGESIZEINBYTES;
    public static final int SCRATCHMEMUSAGEINBYTES;

    VkShaderResourceUsageAMD(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkShaderResourceUsageAMD(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkShaderResourceUsageAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int numUsedVgprs() {
        return VkShaderResourceUsageAMD.nnumUsedVgprs(this.address());
    }

    @NativeType(value="uint32_t")
    public int numUsedSgprs() {
        return VkShaderResourceUsageAMD.nnumUsedSgprs(this.address());
    }

    @NativeType(value="uint32_t")
    public int ldsSizePerLocalWorkGroup() {
        return VkShaderResourceUsageAMD.nldsSizePerLocalWorkGroup(this.address());
    }

    @NativeType(value="size_t")
    public long ldsUsageSizeInBytes() {
        return VkShaderResourceUsageAMD.nldsUsageSizeInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long scratchMemUsageInBytes() {
        return VkShaderResourceUsageAMD.nscratchMemUsageInBytes(this.address());
    }

    public static VkShaderResourceUsageAMD create(long address) {
        return new VkShaderResourceUsageAMD(address, null);
    }

    @Nullable
    public static VkShaderResourceUsageAMD createSafe(long address) {
        return address == 0L ? null : VkShaderResourceUsageAMD.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkShaderResourceUsageAMD.create(address, capacity);
    }

    public static int nnumUsedVgprs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMUSEDVGPRS);
    }

    public static int nnumUsedSgprs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMUSEDSGPRS);
    }

    public static int nldsSizePerLocalWorkGroup(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LDSSIZEPERLOCALWORKGROUP);
    }

    public static long nldsUsageSizeInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LDSUSAGESIZEINBYTES);
    }

    public static long nscratchMemUsageInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SCRATCHMEMUSAGEINBYTES);
    }

    static {
        Struct.Layout layout = VkShaderResourceUsageAMD.__struct(VkShaderResourceUsageAMD.__member(4), VkShaderResourceUsageAMD.__member(4), VkShaderResourceUsageAMD.__member(4), VkShaderResourceUsageAMD.__member(POINTER_SIZE), VkShaderResourceUsageAMD.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUMUSEDVGPRS = layout.offsetof(0);
        NUMUSEDSGPRS = layout.offsetof(1);
        LDSSIZEPERLOCALWORKGROUP = layout.offsetof(2);
        LDSUSAGESIZEINBYTES = layout.offsetof(3);
        SCRATCHMEMUSAGEINBYTES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkShaderResourceUsageAMD, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkShaderResourceUsageAMD newInstance(long address) {
            return new VkShaderResourceUsageAMD(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int numUsedVgprs() {
            return VkShaderResourceUsageAMD.nnumUsedVgprs(this.address());
        }

        @NativeType(value="uint32_t")
        public int numUsedSgprs() {
            return VkShaderResourceUsageAMD.nnumUsedSgprs(this.address());
        }

        @NativeType(value="uint32_t")
        public int ldsSizePerLocalWorkGroup() {
            return VkShaderResourceUsageAMD.nldsSizePerLocalWorkGroup(this.address());
        }

        @NativeType(value="size_t")
        public long ldsUsageSizeInBytes() {
            return VkShaderResourceUsageAMD.nldsUsageSizeInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long scratchMemUsageInBytes() {
            return VkShaderResourceUsageAMD.nscratchMemUsageInBytes(this.address());
        }
    }
}

