/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentDescription2KHR;
import org.lwjgl.vulkan.VkSubpassDependency2KHR;
import org.lwjgl.vulkan.VkSubpassDescription2KHR;

public class VkRenderPassCreateInfo2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int SUBPASSCOUNT;
    public static final int PSUBPASSES;
    public static final int DEPENDENCYCOUNT;
    public static final int PDEPENDENCIES;
    public static final int CORRELATEDVIEWMASKCOUNT;
    public static final int PCORRELATEDVIEWMASKS;

    VkRenderPassCreateInfo2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkRenderPassCreateInfo2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRenderPassCreateInfo2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassCreateInfo2KHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassCreateInfo2KHR.npNext(this.address());
    }

    @NativeType(value="VkRenderPassCreateFlags")
    public int flags() {
        return VkRenderPassCreateInfo2KHR.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkRenderPassCreateInfo2KHR.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentDescription2KHR const *")
    public VkAttachmentDescription2KHR.Buffer pAttachments() {
        return VkRenderPassCreateInfo2KHR.npAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpassCount() {
        return VkRenderPassCreateInfo2KHR.nsubpassCount(this.address());
    }

    @NativeType(value="VkSubpassDescription2KHR const *")
    public VkSubpassDescription2KHR.Buffer pSubpasses() {
        return VkRenderPassCreateInfo2KHR.npSubpasses(this.address());
    }

    @NativeType(value="uint32_t")
    public int dependencyCount() {
        return VkRenderPassCreateInfo2KHR.ndependencyCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSubpassDependency2KHR const *")
    public VkSubpassDependency2KHR.Buffer pDependencies() {
        return VkRenderPassCreateInfo2KHR.npDependencies(this.address());
    }

    @NativeType(value="uint32_t")
    public int correlatedViewMaskCount() {
        return VkRenderPassCreateInfo2KHR.ncorrelatedViewMaskCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pCorrelatedViewMasks() {
        return VkRenderPassCreateInfo2KHR.npCorrelatedViewMasks(this.address());
    }

    public VkRenderPassCreateInfo2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassCreateInfo2KHR.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2KHR pNext(@NativeType(value="void const *") long value) {
        VkRenderPassCreateInfo2KHR.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2KHR flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
        VkRenderPassCreateInfo2KHR.nflags(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2KHR pAttachments(@Nullable @NativeType(value="VkAttachmentDescription2KHR const *") VkAttachmentDescription2KHR.Buffer value) {
        VkRenderPassCreateInfo2KHR.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2KHR pSubpasses(@NativeType(value="VkSubpassDescription2KHR const *") VkSubpassDescription2KHR.Buffer value) {
        VkRenderPassCreateInfo2KHR.npSubpasses(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2KHR pDependencies(@Nullable @NativeType(value="VkSubpassDependency2KHR const *") VkSubpassDependency2KHR.Buffer value) {
        VkRenderPassCreateInfo2KHR.npDependencies(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2KHR pCorrelatedViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassCreateInfo2KHR.npCorrelatedViewMasks(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2KHR set(int sType, long pNext, int flags, @Nullable VkAttachmentDescription2KHR.Buffer pAttachments, VkSubpassDescription2KHR.Buffer pSubpasses, @Nullable VkSubpassDependency2KHR.Buffer pDependencies, @Nullable IntBuffer pCorrelatedViewMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pAttachments(pAttachments);
        this.pSubpasses(pSubpasses);
        this.pDependencies(pDependencies);
        this.pCorrelatedViewMasks(pCorrelatedViewMasks);
        return this;
    }

    public VkRenderPassCreateInfo2KHR set(VkRenderPassCreateInfo2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassCreateInfo2KHR malloc() {
        return VkRenderPassCreateInfo2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRenderPassCreateInfo2KHR calloc() {
        return VkRenderPassCreateInfo2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRenderPassCreateInfo2KHR create() {
        return new VkRenderPassCreateInfo2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRenderPassCreateInfo2KHR create(long address) {
        return new VkRenderPassCreateInfo2KHR(address, null);
    }

    @Nullable
    public static VkRenderPassCreateInfo2KHR createSafe(long address) {
        return address == 0L ? null : VkRenderPassCreateInfo2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassCreateInfo2KHR.create(VkRenderPassCreateInfo2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassCreateInfo2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkRenderPassCreateInfo2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRenderPassCreateInfo2KHR.create(address, capacity);
    }

    public static VkRenderPassCreateInfo2KHR mallocStack() {
        return VkRenderPassCreateInfo2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassCreateInfo2KHR callocStack() {
        return VkRenderPassCreateInfo2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassCreateInfo2KHR mallocStack(MemoryStack stack) {
        return VkRenderPassCreateInfo2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassCreateInfo2KHR callocStack(MemoryStack stack) {
        return VkRenderPassCreateInfo2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassCreateInfo2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassCreateInfo2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassCreateInfo2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassCreateInfo2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nattachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentDescription2KHR.Buffer npAttachments(long struct) {
        return VkAttachmentDescription2KHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS), VkRenderPassCreateInfo2KHR.nattachmentCount(struct));
    }

    public static int nsubpassCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASSCOUNT);
    }

    public static VkSubpassDescription2KHR.Buffer npSubpasses(long struct) {
        return VkSubpassDescription2KHR.create(MemoryUtil.memGetAddress(struct + (long)PSUBPASSES), VkRenderPassCreateInfo2KHR.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPENDENCYCOUNT);
    }

    @Nullable
    public static VkSubpassDependency2KHR.Buffer npDependencies(long struct) {
        return VkSubpassDependency2KHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEPENDENCIES), VkRenderPassCreateInfo2KHR.ndependencyCount(struct));
    }

    public static int ncorrelatedViewMaskCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CORRELATEDVIEWMASKCOUNT);
    }

    @Nullable
    public static IntBuffer npCorrelatedViewMasks(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCORRELATEDVIEWMASKS), VkRenderPassCreateInfo2KHR.ncorrelatedViewMaskCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nattachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable VkAttachmentDescription2KHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkRenderPassCreateInfo2KHR.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsubpassCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASSCOUNT, value);
    }

    public static void npSubpasses(long struct, VkSubpassDescription2KHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSUBPASSES, value.address());
        VkRenderPassCreateInfo2KHR.nsubpassCount(struct, value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPENDENCYCOUNT, value);
    }

    public static void npDependencies(long struct, @Nullable VkSubpassDependency2KHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPENDENCIES, MemoryUtil.memAddressSafe(value));
        VkRenderPassCreateInfo2KHR.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncorrelatedViewMaskCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CORRELATEDVIEWMASKCOUNT, value);
    }

    public static void npCorrelatedViewMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCORRELATEDVIEWMASKS, MemoryUtil.memAddressSafe(value));
        VkRenderPassCreateInfo2KHR.ncorrelatedViewMaskCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassCreateInfo2KHR.nattachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS));
        }
        int subpassCount = VkRenderPassCreateInfo2KHR.nsubpassCount(struct);
        long pSubpasses = MemoryUtil.memGetAddress(struct + (long)PSUBPASSES);
        Checks.check(pSubpasses);
        VkSubpassDescription2KHR.validate(pSubpasses, subpassCount);
        if (VkRenderPassCreateInfo2KHR.ndependencyCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEPENDENCIES));
        }
        if (VkRenderPassCreateInfo2KHR.ncorrelatedViewMaskCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCORRELATEDVIEWMASKS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassCreateInfo2KHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassCreateInfo2KHR.__struct(VkRenderPassCreateInfo2KHR.__member(4), VkRenderPassCreateInfo2KHR.__member(POINTER_SIZE), VkRenderPassCreateInfo2KHR.__member(4), VkRenderPassCreateInfo2KHR.__member(4), VkRenderPassCreateInfo2KHR.__member(POINTER_SIZE), VkRenderPassCreateInfo2KHR.__member(4), VkRenderPassCreateInfo2KHR.__member(POINTER_SIZE), VkRenderPassCreateInfo2KHR.__member(4), VkRenderPassCreateInfo2KHR.__member(POINTER_SIZE), VkRenderPassCreateInfo2KHR.__member(4), VkRenderPassCreateInfo2KHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        ATTACHMENTCOUNT = layout.offsetof(3);
        PATTACHMENTS = layout.offsetof(4);
        SUBPASSCOUNT = layout.offsetof(5);
        PSUBPASSES = layout.offsetof(6);
        DEPENDENCYCOUNT = layout.offsetof(7);
        PDEPENDENCIES = layout.offsetof(8);
        CORRELATEDVIEWMASKCOUNT = layout.offsetof(9);
        PCORRELATEDVIEWMASKS = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassCreateInfo2KHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRenderPassCreateInfo2KHR newInstance(long address) {
            return new VkRenderPassCreateInfo2KHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassCreateInfo2KHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassCreateInfo2KHR.npNext(this.address());
        }

        @NativeType(value="VkRenderPassCreateFlags")
        public int flags() {
            return VkRenderPassCreateInfo2KHR.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkRenderPassCreateInfo2KHR.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentDescription2KHR const *")
        public VkAttachmentDescription2KHR.Buffer pAttachments() {
            return VkRenderPassCreateInfo2KHR.npAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpassCount() {
            return VkRenderPassCreateInfo2KHR.nsubpassCount(this.address());
        }

        @NativeType(value="VkSubpassDescription2KHR const *")
        public VkSubpassDescription2KHR.Buffer pSubpasses() {
            return VkRenderPassCreateInfo2KHR.npSubpasses(this.address());
        }

        @NativeType(value="uint32_t")
        public int dependencyCount() {
            return VkRenderPassCreateInfo2KHR.ndependencyCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSubpassDependency2KHR const *")
        public VkSubpassDependency2KHR.Buffer pDependencies() {
            return VkRenderPassCreateInfo2KHR.npDependencies(this.address());
        }

        @NativeType(value="uint32_t")
        public int correlatedViewMaskCount() {
            return VkRenderPassCreateInfo2KHR.ncorrelatedViewMaskCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pCorrelatedViewMasks() {
            return VkRenderPassCreateInfo2KHR.npCorrelatedViewMasks(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassCreateInfo2KHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassCreateInfo2KHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
            VkRenderPassCreateInfo2KHR.nflags(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkAttachmentDescription2KHR const *") VkAttachmentDescription2KHR.Buffer value) {
            VkRenderPassCreateInfo2KHR.npAttachments(this.address(), value);
            return this;
        }

        public Buffer pSubpasses(@NativeType(value="VkSubpassDescription2KHR const *") VkSubpassDescription2KHR.Buffer value) {
            VkRenderPassCreateInfo2KHR.npSubpasses(this.address(), value);
            return this;
        }

        public Buffer pDependencies(@Nullable @NativeType(value="VkSubpassDependency2KHR const *") VkSubpassDependency2KHR.Buffer value) {
            VkRenderPassCreateInfo2KHR.npDependencies(this.address(), value);
            return this;
        }

        public Buffer pCorrelatedViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassCreateInfo2KHR.npCorrelatedViewMasks(this.address(), value);
            return this;
        }
    }
}

