/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRectLayerKHR;

public class VkPresentRegionKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RECTANGLECOUNT;
    public static final int PRECTANGLES;

    VkPresentRegionKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPresentRegionKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPresentRegionKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int rectangleCount() {
        return VkPresentRegionKHR.nrectangleCount(this.address());
    }

    @Nullable
    @NativeType(value="VkRectLayerKHR const *")
    public VkRectLayerKHR.Buffer pRectangles() {
        return VkPresentRegionKHR.npRectangles(this.address());
    }

    public VkPresentRegionKHR rectangleCount(@NativeType(value="uint32_t") int value) {
        VkPresentRegionKHR.nrectangleCount(this.address(), value);
        return this;
    }

    public VkPresentRegionKHR pRectangles(@Nullable @NativeType(value="VkRectLayerKHR const *") VkRectLayerKHR.Buffer value) {
        VkPresentRegionKHR.npRectangles(this.address(), value);
        return this;
    }

    public VkPresentRegionKHR set(int rectangleCount, @Nullable VkRectLayerKHR.Buffer pRectangles) {
        this.rectangleCount(rectangleCount);
        this.pRectangles(pRectangles);
        return this;
    }

    public VkPresentRegionKHR set(VkPresentRegionKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPresentRegionKHR malloc() {
        return VkPresentRegionKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPresentRegionKHR calloc() {
        return VkPresentRegionKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPresentRegionKHR create() {
        return new VkPresentRegionKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPresentRegionKHR create(long address) {
        return new VkPresentRegionKHR(address, null);
    }

    @Nullable
    public static VkPresentRegionKHR createSafe(long address) {
        return address == 0L ? null : VkPresentRegionKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPresentRegionKHR.create(VkPresentRegionKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPresentRegionKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPresentRegionKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPresentRegionKHR.create(address, capacity);
    }

    public static VkPresentRegionKHR mallocStack() {
        return VkPresentRegionKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkPresentRegionKHR callocStack() {
        return VkPresentRegionKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkPresentRegionKHR mallocStack(MemoryStack stack) {
        return VkPresentRegionKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPresentRegionKHR callocStack(MemoryStack stack) {
        return VkPresentRegionKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPresentRegionKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPresentRegionKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPresentRegionKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPresentRegionKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nrectangleCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RECTANGLECOUNT);
    }

    @Nullable
    public static VkRectLayerKHR.Buffer npRectangles(long struct) {
        return VkRectLayerKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PRECTANGLES), VkPresentRegionKHR.nrectangleCount(struct));
    }

    public static void nrectangleCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RECTANGLECOUNT, value);
    }

    public static void npRectangles(long struct, @Nullable VkRectLayerKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRECTANGLES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPresentRegionKHR.nrectangleCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPresentRegionKHR.__struct(VkPresentRegionKHR.__member(4), VkPresentRegionKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RECTANGLECOUNT = layout.offsetof(0);
        PRECTANGLES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkPresentRegionKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPresentRegionKHR newInstance(long address) {
            return new VkPresentRegionKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int rectangleCount() {
            return VkPresentRegionKHR.nrectangleCount(this.address());
        }

        @Nullable
        @NativeType(value="VkRectLayerKHR const *")
        public VkRectLayerKHR.Buffer pRectangles() {
            return VkPresentRegionKHR.npRectangles(this.address());
        }

        public Buffer rectangleCount(@NativeType(value="uint32_t") int value) {
            VkPresentRegionKHR.nrectangleCount(this.address(), value);
            return this;
        }

        public Buffer pRectangles(@Nullable @NativeType(value="VkRectLayerKHR const *") VkRectLayerKHR.Buffer value) {
            VkPresentRegionKHR.npRectangles(this.address(), value);
            return this;
        }
    }
}

