/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceProtectedMemoryProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROTECTEDNOFAULT;

    VkPhysicalDeviceProtectedMemoryProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceProtectedMemoryProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceProtectedMemoryProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean protectedNoFault() {
        return VkPhysicalDeviceProtectedMemoryProperties.nprotectedNoFault(this.address()) != 0;
    }

    public VkPhysicalDeviceProtectedMemoryProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryProperties protectedNoFault(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceProtectedMemoryProperties.nprotectedNoFault(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryProperties set(int sType, long pNext, boolean protectedNoFault) {
        this.sType(sType);
        this.pNext(pNext);
        this.protectedNoFault(protectedNoFault);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryProperties set(VkPhysicalDeviceProtectedMemoryProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceProtectedMemoryProperties malloc() {
        return VkPhysicalDeviceProtectedMemoryProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryProperties calloc() {
        return VkPhysicalDeviceProtectedMemoryProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryProperties create() {
        return new VkPhysicalDeviceProtectedMemoryProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryProperties create(long address) {
        return new VkPhysicalDeviceProtectedMemoryProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceProtectedMemoryProperties createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceProtectedMemoryProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceProtectedMemoryProperties.create(VkPhysicalDeviceProtectedMemoryProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceProtectedMemoryProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPhysicalDeviceProtectedMemoryProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceProtectedMemoryProperties.create(address, capacity);
    }

    public static VkPhysicalDeviceProtectedMemoryProperties mallocStack() {
        return VkPhysicalDeviceProtectedMemoryProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProtectedMemoryProperties callocStack() {
        return VkPhysicalDeviceProtectedMemoryProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProtectedMemoryProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprotectedNoFault(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROTECTEDNOFAULT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nprotectedNoFault(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PROTECTEDNOFAULT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProtectedMemoryProperties.__struct(VkPhysicalDeviceProtectedMemoryProperties.__member(4), VkPhysicalDeviceProtectedMemoryProperties.__member(POINTER_SIZE), VkPhysicalDeviceProtectedMemoryProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROTECTEDNOFAULT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProtectedMemoryProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceProtectedMemoryProperties newInstance(long address) {
            return new VkPhysicalDeviceProtectedMemoryProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean protectedNoFault() {
            return VkPhysicalDeviceProtectedMemoryProperties.nprotectedNoFault(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address(), value);
            return this;
        }

        public Buffer protectedNoFault(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceProtectedMemoryProperties.nprotectedNoFault(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

