/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceLimits
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXIMAGEDIMENSION1D;
    public static final int MAXIMAGEDIMENSION2D;
    public static final int MAXIMAGEDIMENSION3D;
    public static final int MAXIMAGEDIMENSIONCUBE;
    public static final int MAXIMAGEARRAYLAYERS;
    public static final int MAXTEXELBUFFERELEMENTS;
    public static final int MAXUNIFORMBUFFERRANGE;
    public static final int MAXSTORAGEBUFFERRANGE;
    public static final int MAXPUSHCONSTANTSSIZE;
    public static final int MAXMEMORYALLOCATIONCOUNT;
    public static final int MAXSAMPLERALLOCATIONCOUNT;
    public static final int BUFFERIMAGEGRANULARITY;
    public static final int SPARSEADDRESSSPACESIZE;
    public static final int MAXBOUNDDESCRIPTORSETS;
    public static final int MAXPERSTAGEDESCRIPTORSAMPLERS;
    public static final int MAXPERSTAGEDESCRIPTORUNIFORMBUFFERS;
    public static final int MAXPERSTAGEDESCRIPTORSTORAGEBUFFERS;
    public static final int MAXPERSTAGEDESCRIPTORSAMPLEDIMAGES;
    public static final int MAXPERSTAGEDESCRIPTORSTORAGEIMAGES;
    public static final int MAXPERSTAGEDESCRIPTORINPUTATTACHMENTS;
    public static final int MAXPERSTAGERESOURCES;
    public static final int MAXDESCRIPTORSETSAMPLERS;
    public static final int MAXDESCRIPTORSETUNIFORMBUFFERS;
    public static final int MAXDESCRIPTORSETUNIFORMBUFFERSDYNAMIC;
    public static final int MAXDESCRIPTORSETSTORAGEBUFFERS;
    public static final int MAXDESCRIPTORSETSTORAGEBUFFERSDYNAMIC;
    public static final int MAXDESCRIPTORSETSAMPLEDIMAGES;
    public static final int MAXDESCRIPTORSETSTORAGEIMAGES;
    public static final int MAXDESCRIPTORSETINPUTATTACHMENTS;
    public static final int MAXVERTEXINPUTATTRIBUTES;
    public static final int MAXVERTEXINPUTBINDINGS;
    public static final int MAXVERTEXINPUTATTRIBUTEOFFSET;
    public static final int MAXVERTEXINPUTBINDINGSTRIDE;
    public static final int MAXVERTEXOUTPUTCOMPONENTS;
    public static final int MAXTESSELLATIONGENERATIONLEVEL;
    public static final int MAXTESSELLATIONPATCHSIZE;
    public static final int MAXTESSELLATIONCONTROLPERVERTEXINPUTCOMPONENTS;
    public static final int MAXTESSELLATIONCONTROLPERVERTEXOUTPUTCOMPONENTS;
    public static final int MAXTESSELLATIONCONTROLPERPATCHOUTPUTCOMPONENTS;
    public static final int MAXTESSELLATIONCONTROLTOTALOUTPUTCOMPONENTS;
    public static final int MAXTESSELLATIONEVALUATIONINPUTCOMPONENTS;
    public static final int MAXTESSELLATIONEVALUATIONOUTPUTCOMPONENTS;
    public static final int MAXGEOMETRYSHADERINVOCATIONS;
    public static final int MAXGEOMETRYINPUTCOMPONENTS;
    public static final int MAXGEOMETRYOUTPUTCOMPONENTS;
    public static final int MAXGEOMETRYOUTPUTVERTICES;
    public static final int MAXGEOMETRYTOTALOUTPUTCOMPONENTS;
    public static final int MAXFRAGMENTINPUTCOMPONENTS;
    public static final int MAXFRAGMENTOUTPUTATTACHMENTS;
    public static final int MAXFRAGMENTDUALSRCATTACHMENTS;
    public static final int MAXFRAGMENTCOMBINEDOUTPUTRESOURCES;
    public static final int MAXCOMPUTESHAREDMEMORYSIZE;
    public static final int MAXCOMPUTEWORKGROUPCOUNT;
    public static final int MAXCOMPUTEWORKGROUPINVOCATIONS;
    public static final int MAXCOMPUTEWORKGROUPSIZE;
    public static final int SUBPIXELPRECISIONBITS;
    public static final int SUBTEXELPRECISIONBITS;
    public static final int MIPMAPPRECISIONBITS;
    public static final int MAXDRAWINDEXEDINDEXVALUE;
    public static final int MAXDRAWINDIRECTCOUNT;
    public static final int MAXSAMPLERLODBIAS;
    public static final int MAXSAMPLERANISOTROPY;
    public static final int MAXVIEWPORTS;
    public static final int MAXVIEWPORTDIMENSIONS;
    public static final int VIEWPORTBOUNDSRANGE;
    public static final int VIEWPORTSUBPIXELBITS;
    public static final int MINMEMORYMAPALIGNMENT;
    public static final int MINTEXELBUFFEROFFSETALIGNMENT;
    public static final int MINUNIFORMBUFFEROFFSETALIGNMENT;
    public static final int MINSTORAGEBUFFEROFFSETALIGNMENT;
    public static final int MINTEXELOFFSET;
    public static final int MAXTEXELOFFSET;
    public static final int MINTEXELGATHEROFFSET;
    public static final int MAXTEXELGATHEROFFSET;
    public static final int MININTERPOLATIONOFFSET;
    public static final int MAXINTERPOLATIONOFFSET;
    public static final int SUBPIXELINTERPOLATIONOFFSETBITS;
    public static final int MAXFRAMEBUFFERWIDTH;
    public static final int MAXFRAMEBUFFERHEIGHT;
    public static final int MAXFRAMEBUFFERLAYERS;
    public static final int FRAMEBUFFERCOLORSAMPLECOUNTS;
    public static final int FRAMEBUFFERDEPTHSAMPLECOUNTS;
    public static final int FRAMEBUFFERSTENCILSAMPLECOUNTS;
    public static final int FRAMEBUFFERNOATTACHMENTSSAMPLECOUNTS;
    public static final int MAXCOLORATTACHMENTS;
    public static final int SAMPLEDIMAGECOLORSAMPLECOUNTS;
    public static final int SAMPLEDIMAGEINTEGERSAMPLECOUNTS;
    public static final int SAMPLEDIMAGEDEPTHSAMPLECOUNTS;
    public static final int SAMPLEDIMAGESTENCILSAMPLECOUNTS;
    public static final int STORAGEIMAGESAMPLECOUNTS;
    public static final int MAXSAMPLEMASKWORDS;
    public static final int TIMESTAMPCOMPUTEANDGRAPHICS;
    public static final int TIMESTAMPPERIOD;
    public static final int MAXCLIPDISTANCES;
    public static final int MAXCULLDISTANCES;
    public static final int MAXCOMBINEDCLIPANDCULLDISTANCES;
    public static final int DISCRETEQUEUEPRIORITIES;
    public static final int POINTSIZERANGE;
    public static final int LINEWIDTHRANGE;
    public static final int POINTSIZEGRANULARITY;
    public static final int LINEWIDTHGRANULARITY;
    public static final int STRICTLINES;
    public static final int STANDARDSAMPLELOCATIONS;
    public static final int OPTIMALBUFFERCOPYOFFSETALIGNMENT;
    public static final int OPTIMALBUFFERCOPYROWPITCHALIGNMENT;
    public static final int NONCOHERENTATOMSIZE;

    VkPhysicalDeviceLimits(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceLimits(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceLimits.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int maxImageDimension1D() {
        return VkPhysicalDeviceLimits.nmaxImageDimension1D(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageDimension2D() {
        return VkPhysicalDeviceLimits.nmaxImageDimension2D(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageDimension3D() {
        return VkPhysicalDeviceLimits.nmaxImageDimension3D(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageDimensionCube() {
        return VkPhysicalDeviceLimits.nmaxImageDimensionCube(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageArrayLayers() {
        return VkPhysicalDeviceLimits.nmaxImageArrayLayers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTexelBufferElements() {
        return VkPhysicalDeviceLimits.nmaxTexelBufferElements(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxUniformBufferRange() {
        return VkPhysicalDeviceLimits.nmaxUniformBufferRange(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxStorageBufferRange() {
        return VkPhysicalDeviceLimits.nmaxStorageBufferRange(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPushConstantsSize() {
        return VkPhysicalDeviceLimits.nmaxPushConstantsSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxMemoryAllocationCount() {
        return VkPhysicalDeviceLimits.nmaxMemoryAllocationCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxSamplerAllocationCount() {
        return VkPhysicalDeviceLimits.nmaxSamplerAllocationCount(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long bufferImageGranularity() {
        return VkPhysicalDeviceLimits.nbufferImageGranularity(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long sparseAddressSpaceSize() {
        return VkPhysicalDeviceLimits.nsparseAddressSpaceSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxBoundDescriptorSets() {
        return VkPhysicalDeviceLimits.nmaxBoundDescriptorSets(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorSamplers() {
        return VkPhysicalDeviceLimits.nmaxPerStageDescriptorSamplers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorUniformBuffers() {
        return VkPhysicalDeviceLimits.nmaxPerStageDescriptorUniformBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorStorageBuffers() {
        return VkPhysicalDeviceLimits.nmaxPerStageDescriptorStorageBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorSampledImages() {
        return VkPhysicalDeviceLimits.nmaxPerStageDescriptorSampledImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorStorageImages() {
        return VkPhysicalDeviceLimits.nmaxPerStageDescriptorStorageImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorInputAttachments() {
        return VkPhysicalDeviceLimits.nmaxPerStageDescriptorInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageResources() {
        return VkPhysicalDeviceLimits.nmaxPerStageResources(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetSamplers() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetSamplers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUniformBuffers() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetUniformBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUniformBuffersDynamic() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetUniformBuffersDynamic(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetStorageBuffers() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetStorageBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetStorageBuffersDynamic() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetStorageBuffersDynamic(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetSampledImages() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetSampledImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetStorageImages() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetStorageImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetInputAttachments() {
        return VkPhysicalDeviceLimits.nmaxDescriptorSetInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexInputAttributes() {
        return VkPhysicalDeviceLimits.nmaxVertexInputAttributes(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexInputBindings() {
        return VkPhysicalDeviceLimits.nmaxVertexInputBindings(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexInputAttributeOffset() {
        return VkPhysicalDeviceLimits.nmaxVertexInputAttributeOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexInputBindingStride() {
        return VkPhysicalDeviceLimits.nmaxVertexInputBindingStride(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexOutputComponents() {
        return VkPhysicalDeviceLimits.nmaxVertexOutputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationGenerationLevel() {
        return VkPhysicalDeviceLimits.nmaxTessellationGenerationLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationPatchSize() {
        return VkPhysicalDeviceLimits.nmaxTessellationPatchSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationControlPerVertexInputComponents() {
        return VkPhysicalDeviceLimits.nmaxTessellationControlPerVertexInputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationControlPerVertexOutputComponents() {
        return VkPhysicalDeviceLimits.nmaxTessellationControlPerVertexOutputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationControlPerPatchOutputComponents() {
        return VkPhysicalDeviceLimits.nmaxTessellationControlPerPatchOutputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationControlTotalOutputComponents() {
        return VkPhysicalDeviceLimits.nmaxTessellationControlTotalOutputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationEvaluationInputComponents() {
        return VkPhysicalDeviceLimits.nmaxTessellationEvaluationInputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTessellationEvaluationOutputComponents() {
        return VkPhysicalDeviceLimits.nmaxTessellationEvaluationOutputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxGeometryShaderInvocations() {
        return VkPhysicalDeviceLimits.nmaxGeometryShaderInvocations(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxGeometryInputComponents() {
        return VkPhysicalDeviceLimits.nmaxGeometryInputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxGeometryOutputComponents() {
        return VkPhysicalDeviceLimits.nmaxGeometryOutputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxGeometryOutputVertices() {
        return VkPhysicalDeviceLimits.nmaxGeometryOutputVertices(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxGeometryTotalOutputComponents() {
        return VkPhysicalDeviceLimits.nmaxGeometryTotalOutputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFragmentInputComponents() {
        return VkPhysicalDeviceLimits.nmaxFragmentInputComponents(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFragmentOutputAttachments() {
        return VkPhysicalDeviceLimits.nmaxFragmentOutputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFragmentDualSrcAttachments() {
        return VkPhysicalDeviceLimits.nmaxFragmentDualSrcAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFragmentCombinedOutputResources() {
        return VkPhysicalDeviceLimits.nmaxFragmentCombinedOutputResources(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxComputeSharedMemorySize() {
        return VkPhysicalDeviceLimits.nmaxComputeSharedMemorySize(this.address());
    }

    @NativeType(value="uint32_t[3]")
    public IntBuffer maxComputeWorkGroupCount() {
        return VkPhysicalDeviceLimits.nmaxComputeWorkGroupCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxComputeWorkGroupCount(int index) {
        return VkPhysicalDeviceLimits.nmaxComputeWorkGroupCount(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int maxComputeWorkGroupInvocations() {
        return VkPhysicalDeviceLimits.nmaxComputeWorkGroupInvocations(this.address());
    }

    @NativeType(value="uint32_t[3]")
    public IntBuffer maxComputeWorkGroupSize() {
        return VkPhysicalDeviceLimits.nmaxComputeWorkGroupSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxComputeWorkGroupSize(int index) {
        return VkPhysicalDeviceLimits.nmaxComputeWorkGroupSize(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int subPixelPrecisionBits() {
        return VkPhysicalDeviceLimits.nsubPixelPrecisionBits(this.address());
    }

    @NativeType(value="uint32_t")
    public int subTexelPrecisionBits() {
        return VkPhysicalDeviceLimits.nsubTexelPrecisionBits(this.address());
    }

    @NativeType(value="uint32_t")
    public int mipmapPrecisionBits() {
        return VkPhysicalDeviceLimits.nmipmapPrecisionBits(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDrawIndexedIndexValue() {
        return VkPhysicalDeviceLimits.nmaxDrawIndexedIndexValue(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDrawIndirectCount() {
        return VkPhysicalDeviceLimits.nmaxDrawIndirectCount(this.address());
    }

    public float maxSamplerLodBias() {
        return VkPhysicalDeviceLimits.nmaxSamplerLodBias(this.address());
    }

    public float maxSamplerAnisotropy() {
        return VkPhysicalDeviceLimits.nmaxSamplerAnisotropy(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxViewports() {
        return VkPhysicalDeviceLimits.nmaxViewports(this.address());
    }

    @NativeType(value="uint32_t[2]")
    public IntBuffer maxViewportDimensions() {
        return VkPhysicalDeviceLimits.nmaxViewportDimensions(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxViewportDimensions(int index) {
        return VkPhysicalDeviceLimits.nmaxViewportDimensions(this.address(), index);
    }

    @NativeType(value="float[2]")
    public FloatBuffer viewportBoundsRange() {
        return VkPhysicalDeviceLimits.nviewportBoundsRange(this.address());
    }

    public float viewportBoundsRange(int index) {
        return VkPhysicalDeviceLimits.nviewportBoundsRange(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int viewportSubPixelBits() {
        return VkPhysicalDeviceLimits.nviewportSubPixelBits(this.address());
    }

    @NativeType(value="size_t")
    public long minMemoryMapAlignment() {
        return VkPhysicalDeviceLimits.nminMemoryMapAlignment(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minTexelBufferOffsetAlignment() {
        return VkPhysicalDeviceLimits.nminTexelBufferOffsetAlignment(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minUniformBufferOffsetAlignment() {
        return VkPhysicalDeviceLimits.nminUniformBufferOffsetAlignment(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minStorageBufferOffsetAlignment() {
        return VkPhysicalDeviceLimits.nminStorageBufferOffsetAlignment(this.address());
    }

    @NativeType(value="int32_t")
    public int minTexelOffset() {
        return VkPhysicalDeviceLimits.nminTexelOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTexelOffset() {
        return VkPhysicalDeviceLimits.nmaxTexelOffset(this.address());
    }

    @NativeType(value="int32_t")
    public int minTexelGatherOffset() {
        return VkPhysicalDeviceLimits.nminTexelGatherOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTexelGatherOffset() {
        return VkPhysicalDeviceLimits.nmaxTexelGatherOffset(this.address());
    }

    public float minInterpolationOffset() {
        return VkPhysicalDeviceLimits.nminInterpolationOffset(this.address());
    }

    public float maxInterpolationOffset() {
        return VkPhysicalDeviceLimits.nmaxInterpolationOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int subPixelInterpolationOffsetBits() {
        return VkPhysicalDeviceLimits.nsubPixelInterpolationOffsetBits(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFramebufferWidth() {
        return VkPhysicalDeviceLimits.nmaxFramebufferWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFramebufferHeight() {
        return VkPhysicalDeviceLimits.nmaxFramebufferHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFramebufferLayers() {
        return VkPhysicalDeviceLimits.nmaxFramebufferLayers(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int framebufferColorSampleCounts() {
        return VkPhysicalDeviceLimits.nframebufferColorSampleCounts(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int framebufferDepthSampleCounts() {
        return VkPhysicalDeviceLimits.nframebufferDepthSampleCounts(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int framebufferStencilSampleCounts() {
        return VkPhysicalDeviceLimits.nframebufferStencilSampleCounts(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int framebufferNoAttachmentsSampleCounts() {
        return VkPhysicalDeviceLimits.nframebufferNoAttachmentsSampleCounts(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxColorAttachments() {
        return VkPhysicalDeviceLimits.nmaxColorAttachments(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampledImageColorSampleCounts() {
        return VkPhysicalDeviceLimits.nsampledImageColorSampleCounts(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampledImageIntegerSampleCounts() {
        return VkPhysicalDeviceLimits.nsampledImageIntegerSampleCounts(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampledImageDepthSampleCounts() {
        return VkPhysicalDeviceLimits.nsampledImageDepthSampleCounts(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampledImageStencilSampleCounts() {
        return VkPhysicalDeviceLimits.nsampledImageStencilSampleCounts(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int storageImageSampleCounts() {
        return VkPhysicalDeviceLimits.nstorageImageSampleCounts(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxSampleMaskWords() {
        return VkPhysicalDeviceLimits.nmaxSampleMaskWords(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean timestampComputeAndGraphics() {
        return VkPhysicalDeviceLimits.ntimestampComputeAndGraphics(this.address()) != 0;
    }

    public float timestampPeriod() {
        return VkPhysicalDeviceLimits.ntimestampPeriod(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxClipDistances() {
        return VkPhysicalDeviceLimits.nmaxClipDistances(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxCullDistances() {
        return VkPhysicalDeviceLimits.nmaxCullDistances(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxCombinedClipAndCullDistances() {
        return VkPhysicalDeviceLimits.nmaxCombinedClipAndCullDistances(this.address());
    }

    @NativeType(value="uint32_t")
    public int discreteQueuePriorities() {
        return VkPhysicalDeviceLimits.ndiscreteQueuePriorities(this.address());
    }

    @NativeType(value="float[2]")
    public FloatBuffer pointSizeRange() {
        return VkPhysicalDeviceLimits.npointSizeRange(this.address());
    }

    public float pointSizeRange(int index) {
        return VkPhysicalDeviceLimits.npointSizeRange(this.address(), index);
    }

    @NativeType(value="float[2]")
    public FloatBuffer lineWidthRange() {
        return VkPhysicalDeviceLimits.nlineWidthRange(this.address());
    }

    public float lineWidthRange(int index) {
        return VkPhysicalDeviceLimits.nlineWidthRange(this.address(), index);
    }

    public float pointSizeGranularity() {
        return VkPhysicalDeviceLimits.npointSizeGranularity(this.address());
    }

    public float lineWidthGranularity() {
        return VkPhysicalDeviceLimits.nlineWidthGranularity(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean strictLines() {
        return VkPhysicalDeviceLimits.nstrictLines(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean standardSampleLocations() {
        return VkPhysicalDeviceLimits.nstandardSampleLocations(this.address()) != 0;
    }

    @NativeType(value="VkDeviceSize")
    public long optimalBufferCopyOffsetAlignment() {
        return VkPhysicalDeviceLimits.noptimalBufferCopyOffsetAlignment(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long optimalBufferCopyRowPitchAlignment() {
        return VkPhysicalDeviceLimits.noptimalBufferCopyRowPitchAlignment(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long nonCoherentAtomSize() {
        return VkPhysicalDeviceLimits.nnonCoherentAtomSize(this.address());
    }

    public static VkPhysicalDeviceLimits create(long address) {
        return new VkPhysicalDeviceLimits(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceLimits createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceLimits.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceLimits.create(address, capacity);
    }

    public static int nmaxImageDimension1D(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEDIMENSION1D);
    }

    public static int nmaxImageDimension2D(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEDIMENSION2D);
    }

    public static int nmaxImageDimension3D(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEDIMENSION3D);
    }

    public static int nmaxImageDimensionCube(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEDIMENSIONCUBE);
    }

    public static int nmaxImageArrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEARRAYLAYERS);
    }

    public static int nmaxTexelBufferElements(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTEXELBUFFERELEMENTS);
    }

    public static int nmaxUniformBufferRange(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXUNIFORMBUFFERRANGE);
    }

    public static int nmaxStorageBufferRange(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSTORAGEBUFFERRANGE);
    }

    public static int nmaxPushConstantsSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPUSHCONSTANTSSIZE);
    }

    public static int nmaxMemoryAllocationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXMEMORYALLOCATIONCOUNT);
    }

    public static int nmaxSamplerAllocationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSAMPLERALLOCATIONCOUNT);
    }

    public static long nbufferImageGranularity(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFERIMAGEGRANULARITY);
    }

    public static long nsparseAddressSpaceSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SPARSEADDRESSSPACESIZE);
    }

    public static int nmaxBoundDescriptorSets(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXBOUNDDESCRIPTORSETS);
    }

    public static int nmaxPerStageDescriptorSamplers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPERSTAGEDESCRIPTORSAMPLERS);
    }

    public static int nmaxPerStageDescriptorUniformBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPERSTAGEDESCRIPTORUNIFORMBUFFERS);
    }

    public static int nmaxPerStageDescriptorStorageBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPERSTAGEDESCRIPTORSTORAGEBUFFERS);
    }

    public static int nmaxPerStageDescriptorSampledImages(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPERSTAGEDESCRIPTORSAMPLEDIMAGES);
    }

    public static int nmaxPerStageDescriptorStorageImages(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPERSTAGEDESCRIPTORSTORAGEIMAGES);
    }

    public static int nmaxPerStageDescriptorInputAttachments(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPERSTAGEDESCRIPTORINPUTATTACHMENTS);
    }

    public static int nmaxPerStageResources(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPERSTAGERESOURCES);
    }

    public static int nmaxDescriptorSetSamplers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETSAMPLERS);
    }

    public static int nmaxDescriptorSetUniformBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETUNIFORMBUFFERS);
    }

    public static int nmaxDescriptorSetUniformBuffersDynamic(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETUNIFORMBUFFERSDYNAMIC);
    }

    public static int nmaxDescriptorSetStorageBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETSTORAGEBUFFERS);
    }

    public static int nmaxDescriptorSetStorageBuffersDynamic(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETSTORAGEBUFFERSDYNAMIC);
    }

    public static int nmaxDescriptorSetSampledImages(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETSAMPLEDIMAGES);
    }

    public static int nmaxDescriptorSetStorageImages(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETSTORAGEIMAGES);
    }

    public static int nmaxDescriptorSetInputAttachments(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDESCRIPTORSETINPUTATTACHMENTS);
    }

    public static int nmaxVertexInputAttributes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXINPUTATTRIBUTES);
    }

    public static int nmaxVertexInputBindings(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXINPUTBINDINGS);
    }

    public static int nmaxVertexInputAttributeOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXINPUTATTRIBUTEOFFSET);
    }

    public static int nmaxVertexInputBindingStride(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXINPUTBINDINGSTRIDE);
    }

    public static int nmaxVertexOutputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXOUTPUTCOMPONENTS);
    }

    public static int nmaxTessellationGenerationLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONGENERATIONLEVEL);
    }

    public static int nmaxTessellationPatchSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONPATCHSIZE);
    }

    public static int nmaxTessellationControlPerVertexInputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONCONTROLPERVERTEXINPUTCOMPONENTS);
    }

    public static int nmaxTessellationControlPerVertexOutputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONCONTROLPERVERTEXOUTPUTCOMPONENTS);
    }

    public static int nmaxTessellationControlPerPatchOutputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONCONTROLPERPATCHOUTPUTCOMPONENTS);
    }

    public static int nmaxTessellationControlTotalOutputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONCONTROLTOTALOUTPUTCOMPONENTS);
    }

    public static int nmaxTessellationEvaluationInputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONEVALUATIONINPUTCOMPONENTS);
    }

    public static int nmaxTessellationEvaluationOutputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTESSELLATIONEVALUATIONOUTPUTCOMPONENTS);
    }

    public static int nmaxGeometryShaderInvocations(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXGEOMETRYSHADERINVOCATIONS);
    }

    public static int nmaxGeometryInputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXGEOMETRYINPUTCOMPONENTS);
    }

    public static int nmaxGeometryOutputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXGEOMETRYOUTPUTCOMPONENTS);
    }

    public static int nmaxGeometryOutputVertices(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXGEOMETRYOUTPUTVERTICES);
    }

    public static int nmaxGeometryTotalOutputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXGEOMETRYTOTALOUTPUTCOMPONENTS);
    }

    public static int nmaxFragmentInputComponents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAGMENTINPUTCOMPONENTS);
    }

    public static int nmaxFragmentOutputAttachments(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAGMENTOUTPUTATTACHMENTS);
    }

    public static int nmaxFragmentDualSrcAttachments(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAGMENTDUALSRCATTACHMENTS);
    }

    public static int nmaxFragmentCombinedOutputResources(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAGMENTCOMBINEDOUTPUTRESOURCES);
    }

    public static int nmaxComputeSharedMemorySize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXCOMPUTESHAREDMEMORYSIZE);
    }

    public static IntBuffer nmaxComputeWorkGroupCount(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)MAXCOMPUTEWORKGROUPCOUNT, 3);
    }

    public static int nmaxComputeWorkGroupCount(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)MAXCOMPUTEWORKGROUPCOUNT + Checks.check(index, 3) * 4L);
    }

    public static int nmaxComputeWorkGroupInvocations(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXCOMPUTEWORKGROUPINVOCATIONS);
    }

    public static IntBuffer nmaxComputeWorkGroupSize(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)MAXCOMPUTEWORKGROUPSIZE, 3);
    }

    public static int nmaxComputeWorkGroupSize(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)MAXCOMPUTEWORKGROUPSIZE + Checks.check(index, 3) * 4L);
    }

    public static int nsubPixelPrecisionBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPIXELPRECISIONBITS);
    }

    public static int nsubTexelPrecisionBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBTEXELPRECISIONBITS);
    }

    public static int nmipmapPrecisionBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIPMAPPRECISIONBITS);
    }

    public static int nmaxDrawIndexedIndexValue(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDRAWINDEXEDINDEXVALUE);
    }

    public static int nmaxDrawIndirectCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDRAWINDIRECTCOUNT);
    }

    public static float nmaxSamplerLodBias(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXSAMPLERLODBIAS);
    }

    public static float nmaxSamplerAnisotropy(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXSAMPLERANISOTROPY);
    }

    public static int nmaxViewports(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVIEWPORTS);
    }

    public static IntBuffer nmaxViewportDimensions(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)MAXVIEWPORTDIMENSIONS, 2);
    }

    public static int nmaxViewportDimensions(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)MAXVIEWPORTDIMENSIONS + Checks.check(index, 2) * 4L);
    }

    public static FloatBuffer nviewportBoundsRange(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)VIEWPORTBOUNDSRANGE, 2);
    }

    public static float nviewportBoundsRange(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)VIEWPORTBOUNDSRANGE + Checks.check(index, 2) * 4L);
    }

    public static int nviewportSubPixelBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWPORTSUBPIXELBITS);
    }

    public static long nminMemoryMapAlignment(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MINMEMORYMAPALIGNMENT);
    }

    public static long nminTexelBufferOffsetAlignment(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MINTEXELBUFFEROFFSETALIGNMENT);
    }

    public static long nminUniformBufferOffsetAlignment(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MINUNIFORMBUFFEROFFSETALIGNMENT);
    }

    public static long nminStorageBufferOffsetAlignment(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MINSTORAGEBUFFEROFFSETALIGNMENT);
    }

    public static int nminTexelOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINTEXELOFFSET);
    }

    public static int nmaxTexelOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTEXELOFFSET);
    }

    public static int nminTexelGatherOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINTEXELGATHEROFFSET);
    }

    public static int nmaxTexelGatherOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTEXELGATHEROFFSET);
    }

    public static float nminInterpolationOffset(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MININTERPOLATIONOFFSET);
    }

    public static float nmaxInterpolationOffset(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXINTERPOLATIONOFFSET);
    }

    public static int nsubPixelInterpolationOffsetBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPIXELINTERPOLATIONOFFSETBITS);
    }

    public static int nmaxFramebufferWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAMEBUFFERWIDTH);
    }

    public static int nmaxFramebufferHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAMEBUFFERHEIGHT);
    }

    public static int nmaxFramebufferLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAMEBUFFERLAYERS);
    }

    public static int nframebufferColorSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEBUFFERCOLORSAMPLECOUNTS);
    }

    public static int nframebufferDepthSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEBUFFERDEPTHSAMPLECOUNTS);
    }

    public static int nframebufferStencilSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEBUFFERSTENCILSAMPLECOUNTS);
    }

    public static int nframebufferNoAttachmentsSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEBUFFERNOATTACHMENTSSAMPLECOUNTS);
    }

    public static int nmaxColorAttachments(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXCOLORATTACHMENTS);
    }

    public static int nsampledImageColorSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLEDIMAGECOLORSAMPLECOUNTS);
    }

    public static int nsampledImageIntegerSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLEDIMAGEINTEGERSAMPLECOUNTS);
    }

    public static int nsampledImageDepthSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLEDIMAGEDEPTHSAMPLECOUNTS);
    }

    public static int nsampledImageStencilSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLEDIMAGESTENCILSAMPLECOUNTS);
    }

    public static int nstorageImageSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STORAGEIMAGESAMPLECOUNTS);
    }

    public static int nmaxSampleMaskWords(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSAMPLEMASKWORDS);
    }

    public static int ntimestampComputeAndGraphics(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TIMESTAMPCOMPUTEANDGRAPHICS);
    }

    public static float ntimestampPeriod(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)TIMESTAMPPERIOD);
    }

    public static int nmaxClipDistances(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXCLIPDISTANCES);
    }

    public static int nmaxCullDistances(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXCULLDISTANCES);
    }

    public static int nmaxCombinedClipAndCullDistances(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXCOMBINEDCLIPANDCULLDISTANCES);
    }

    public static int ndiscreteQueuePriorities(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DISCRETEQUEUEPRIORITIES);
    }

    public static FloatBuffer npointSizeRange(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)POINTSIZERANGE, 2);
    }

    public static float npointSizeRange(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)POINTSIZERANGE + Checks.check(index, 2) * 4L);
    }

    public static FloatBuffer nlineWidthRange(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)LINEWIDTHRANGE, 2);
    }

    public static float nlineWidthRange(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)LINEWIDTHRANGE + Checks.check(index, 2) * 4L);
    }

    public static float npointSizeGranularity(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)POINTSIZEGRANULARITY);
    }

    public static float nlineWidthGranularity(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)LINEWIDTHGRANULARITY);
    }

    public static int nstrictLines(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STRICTLINES);
    }

    public static int nstandardSampleLocations(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STANDARDSAMPLELOCATIONS);
    }

    public static long noptimalBufferCopyOffsetAlignment(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OPTIMALBUFFERCOPYOFFSETALIGNMENT);
    }

    public static long noptimalBufferCopyRowPitchAlignment(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OPTIMALBUFFERCOPYROWPITCHALIGNMENT);
    }

    public static long nnonCoherentAtomSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)NONCOHERENTATOMSIZE);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceLimits.__struct(VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(8), VkPhysicalDeviceLimits.__member(8), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__array(4, 3), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__array(4, 3), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__array(4, 2), VkPhysicalDeviceLimits.__array(4, 2), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(POINTER_SIZE), VkPhysicalDeviceLimits.__member(8), VkPhysicalDeviceLimits.__member(8), VkPhysicalDeviceLimits.__member(8), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__array(4, 2), VkPhysicalDeviceLimits.__array(4, 2), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(4), VkPhysicalDeviceLimits.__member(8), VkPhysicalDeviceLimits.__member(8), VkPhysicalDeviceLimits.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXIMAGEDIMENSION1D = layout.offsetof(0);
        MAXIMAGEDIMENSION2D = layout.offsetof(1);
        MAXIMAGEDIMENSION3D = layout.offsetof(2);
        MAXIMAGEDIMENSIONCUBE = layout.offsetof(3);
        MAXIMAGEARRAYLAYERS = layout.offsetof(4);
        MAXTEXELBUFFERELEMENTS = layout.offsetof(5);
        MAXUNIFORMBUFFERRANGE = layout.offsetof(6);
        MAXSTORAGEBUFFERRANGE = layout.offsetof(7);
        MAXPUSHCONSTANTSSIZE = layout.offsetof(8);
        MAXMEMORYALLOCATIONCOUNT = layout.offsetof(9);
        MAXSAMPLERALLOCATIONCOUNT = layout.offsetof(10);
        BUFFERIMAGEGRANULARITY = layout.offsetof(11);
        SPARSEADDRESSSPACESIZE = layout.offsetof(12);
        MAXBOUNDDESCRIPTORSETS = layout.offsetof(13);
        MAXPERSTAGEDESCRIPTORSAMPLERS = layout.offsetof(14);
        MAXPERSTAGEDESCRIPTORUNIFORMBUFFERS = layout.offsetof(15);
        MAXPERSTAGEDESCRIPTORSTORAGEBUFFERS = layout.offsetof(16);
        MAXPERSTAGEDESCRIPTORSAMPLEDIMAGES = layout.offsetof(17);
        MAXPERSTAGEDESCRIPTORSTORAGEIMAGES = layout.offsetof(18);
        MAXPERSTAGEDESCRIPTORINPUTATTACHMENTS = layout.offsetof(19);
        MAXPERSTAGERESOURCES = layout.offsetof(20);
        MAXDESCRIPTORSETSAMPLERS = layout.offsetof(21);
        MAXDESCRIPTORSETUNIFORMBUFFERS = layout.offsetof(22);
        MAXDESCRIPTORSETUNIFORMBUFFERSDYNAMIC = layout.offsetof(23);
        MAXDESCRIPTORSETSTORAGEBUFFERS = layout.offsetof(24);
        MAXDESCRIPTORSETSTORAGEBUFFERSDYNAMIC = layout.offsetof(25);
        MAXDESCRIPTORSETSAMPLEDIMAGES = layout.offsetof(26);
        MAXDESCRIPTORSETSTORAGEIMAGES = layout.offsetof(27);
        MAXDESCRIPTORSETINPUTATTACHMENTS = layout.offsetof(28);
        MAXVERTEXINPUTATTRIBUTES = layout.offsetof(29);
        MAXVERTEXINPUTBINDINGS = layout.offsetof(30);
        MAXVERTEXINPUTATTRIBUTEOFFSET = layout.offsetof(31);
        MAXVERTEXINPUTBINDINGSTRIDE = layout.offsetof(32);
        MAXVERTEXOUTPUTCOMPONENTS = layout.offsetof(33);
        MAXTESSELLATIONGENERATIONLEVEL = layout.offsetof(34);
        MAXTESSELLATIONPATCHSIZE = layout.offsetof(35);
        MAXTESSELLATIONCONTROLPERVERTEXINPUTCOMPONENTS = layout.offsetof(36);
        MAXTESSELLATIONCONTROLPERVERTEXOUTPUTCOMPONENTS = layout.offsetof(37);
        MAXTESSELLATIONCONTROLPERPATCHOUTPUTCOMPONENTS = layout.offsetof(38);
        MAXTESSELLATIONCONTROLTOTALOUTPUTCOMPONENTS = layout.offsetof(39);
        MAXTESSELLATIONEVALUATIONINPUTCOMPONENTS = layout.offsetof(40);
        MAXTESSELLATIONEVALUATIONOUTPUTCOMPONENTS = layout.offsetof(41);
        MAXGEOMETRYSHADERINVOCATIONS = layout.offsetof(42);
        MAXGEOMETRYINPUTCOMPONENTS = layout.offsetof(43);
        MAXGEOMETRYOUTPUTCOMPONENTS = layout.offsetof(44);
        MAXGEOMETRYOUTPUTVERTICES = layout.offsetof(45);
        MAXGEOMETRYTOTALOUTPUTCOMPONENTS = layout.offsetof(46);
        MAXFRAGMENTINPUTCOMPONENTS = layout.offsetof(47);
        MAXFRAGMENTOUTPUTATTACHMENTS = layout.offsetof(48);
        MAXFRAGMENTDUALSRCATTACHMENTS = layout.offsetof(49);
        MAXFRAGMENTCOMBINEDOUTPUTRESOURCES = layout.offsetof(50);
        MAXCOMPUTESHAREDMEMORYSIZE = layout.offsetof(51);
        MAXCOMPUTEWORKGROUPCOUNT = layout.offsetof(52);
        MAXCOMPUTEWORKGROUPINVOCATIONS = layout.offsetof(53);
        MAXCOMPUTEWORKGROUPSIZE = layout.offsetof(54);
        SUBPIXELPRECISIONBITS = layout.offsetof(55);
        SUBTEXELPRECISIONBITS = layout.offsetof(56);
        MIPMAPPRECISIONBITS = layout.offsetof(57);
        MAXDRAWINDEXEDINDEXVALUE = layout.offsetof(58);
        MAXDRAWINDIRECTCOUNT = layout.offsetof(59);
        MAXSAMPLERLODBIAS = layout.offsetof(60);
        MAXSAMPLERANISOTROPY = layout.offsetof(61);
        MAXVIEWPORTS = layout.offsetof(62);
        MAXVIEWPORTDIMENSIONS = layout.offsetof(63);
        VIEWPORTBOUNDSRANGE = layout.offsetof(64);
        VIEWPORTSUBPIXELBITS = layout.offsetof(65);
        MINMEMORYMAPALIGNMENT = layout.offsetof(66);
        MINTEXELBUFFEROFFSETALIGNMENT = layout.offsetof(67);
        MINUNIFORMBUFFEROFFSETALIGNMENT = layout.offsetof(68);
        MINSTORAGEBUFFEROFFSETALIGNMENT = layout.offsetof(69);
        MINTEXELOFFSET = layout.offsetof(70);
        MAXTEXELOFFSET = layout.offsetof(71);
        MINTEXELGATHEROFFSET = layout.offsetof(72);
        MAXTEXELGATHEROFFSET = layout.offsetof(73);
        MININTERPOLATIONOFFSET = layout.offsetof(74);
        MAXINTERPOLATIONOFFSET = layout.offsetof(75);
        SUBPIXELINTERPOLATIONOFFSETBITS = layout.offsetof(76);
        MAXFRAMEBUFFERWIDTH = layout.offsetof(77);
        MAXFRAMEBUFFERHEIGHT = layout.offsetof(78);
        MAXFRAMEBUFFERLAYERS = layout.offsetof(79);
        FRAMEBUFFERCOLORSAMPLECOUNTS = layout.offsetof(80);
        FRAMEBUFFERDEPTHSAMPLECOUNTS = layout.offsetof(81);
        FRAMEBUFFERSTENCILSAMPLECOUNTS = layout.offsetof(82);
        FRAMEBUFFERNOATTACHMENTSSAMPLECOUNTS = layout.offsetof(83);
        MAXCOLORATTACHMENTS = layout.offsetof(84);
        SAMPLEDIMAGECOLORSAMPLECOUNTS = layout.offsetof(85);
        SAMPLEDIMAGEINTEGERSAMPLECOUNTS = layout.offsetof(86);
        SAMPLEDIMAGEDEPTHSAMPLECOUNTS = layout.offsetof(87);
        SAMPLEDIMAGESTENCILSAMPLECOUNTS = layout.offsetof(88);
        STORAGEIMAGESAMPLECOUNTS = layout.offsetof(89);
        MAXSAMPLEMASKWORDS = layout.offsetof(90);
        TIMESTAMPCOMPUTEANDGRAPHICS = layout.offsetof(91);
        TIMESTAMPPERIOD = layout.offsetof(92);
        MAXCLIPDISTANCES = layout.offsetof(93);
        MAXCULLDISTANCES = layout.offsetof(94);
        MAXCOMBINEDCLIPANDCULLDISTANCES = layout.offsetof(95);
        DISCRETEQUEUEPRIORITIES = layout.offsetof(96);
        POINTSIZERANGE = layout.offsetof(97);
        LINEWIDTHRANGE = layout.offsetof(98);
        POINTSIZEGRANULARITY = layout.offsetof(99);
        LINEWIDTHGRANULARITY = layout.offsetof(100);
        STRICTLINES = layout.offsetof(101);
        STANDARDSAMPLELOCATIONS = layout.offsetof(102);
        OPTIMALBUFFERCOPYOFFSETALIGNMENT = layout.offsetof(103);
        OPTIMALBUFFERCOPYROWPITCHALIGNMENT = layout.offsetof(104);
        NONCOHERENTATOMSIZE = layout.offsetof(105);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceLimits, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceLimits newInstance(long address) {
            return new VkPhysicalDeviceLimits(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int maxImageDimension1D() {
            return VkPhysicalDeviceLimits.nmaxImageDimension1D(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageDimension2D() {
            return VkPhysicalDeviceLimits.nmaxImageDimension2D(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageDimension3D() {
            return VkPhysicalDeviceLimits.nmaxImageDimension3D(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageDimensionCube() {
            return VkPhysicalDeviceLimits.nmaxImageDimensionCube(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageArrayLayers() {
            return VkPhysicalDeviceLimits.nmaxImageArrayLayers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTexelBufferElements() {
            return VkPhysicalDeviceLimits.nmaxTexelBufferElements(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxUniformBufferRange() {
            return VkPhysicalDeviceLimits.nmaxUniformBufferRange(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxStorageBufferRange() {
            return VkPhysicalDeviceLimits.nmaxStorageBufferRange(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPushConstantsSize() {
            return VkPhysicalDeviceLimits.nmaxPushConstantsSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxMemoryAllocationCount() {
            return VkPhysicalDeviceLimits.nmaxMemoryAllocationCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxSamplerAllocationCount() {
            return VkPhysicalDeviceLimits.nmaxSamplerAllocationCount(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long bufferImageGranularity() {
            return VkPhysicalDeviceLimits.nbufferImageGranularity(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long sparseAddressSpaceSize() {
            return VkPhysicalDeviceLimits.nsparseAddressSpaceSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxBoundDescriptorSets() {
            return VkPhysicalDeviceLimits.nmaxBoundDescriptorSets(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorSamplers() {
            return VkPhysicalDeviceLimits.nmaxPerStageDescriptorSamplers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorUniformBuffers() {
            return VkPhysicalDeviceLimits.nmaxPerStageDescriptorUniformBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorStorageBuffers() {
            return VkPhysicalDeviceLimits.nmaxPerStageDescriptorStorageBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorSampledImages() {
            return VkPhysicalDeviceLimits.nmaxPerStageDescriptorSampledImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorStorageImages() {
            return VkPhysicalDeviceLimits.nmaxPerStageDescriptorStorageImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorInputAttachments() {
            return VkPhysicalDeviceLimits.nmaxPerStageDescriptorInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageResources() {
            return VkPhysicalDeviceLimits.nmaxPerStageResources(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetSamplers() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetSamplers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUniformBuffers() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetUniformBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUniformBuffersDynamic() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetUniformBuffersDynamic(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetStorageBuffers() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetStorageBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetStorageBuffersDynamic() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetStorageBuffersDynamic(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetSampledImages() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetSampledImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetStorageImages() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetStorageImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetInputAttachments() {
            return VkPhysicalDeviceLimits.nmaxDescriptorSetInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexInputAttributes() {
            return VkPhysicalDeviceLimits.nmaxVertexInputAttributes(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexInputBindings() {
            return VkPhysicalDeviceLimits.nmaxVertexInputBindings(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexInputAttributeOffset() {
            return VkPhysicalDeviceLimits.nmaxVertexInputAttributeOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexInputBindingStride() {
            return VkPhysicalDeviceLimits.nmaxVertexInputBindingStride(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexOutputComponents() {
            return VkPhysicalDeviceLimits.nmaxVertexOutputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationGenerationLevel() {
            return VkPhysicalDeviceLimits.nmaxTessellationGenerationLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationPatchSize() {
            return VkPhysicalDeviceLimits.nmaxTessellationPatchSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationControlPerVertexInputComponents() {
            return VkPhysicalDeviceLimits.nmaxTessellationControlPerVertexInputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationControlPerVertexOutputComponents() {
            return VkPhysicalDeviceLimits.nmaxTessellationControlPerVertexOutputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationControlPerPatchOutputComponents() {
            return VkPhysicalDeviceLimits.nmaxTessellationControlPerPatchOutputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationControlTotalOutputComponents() {
            return VkPhysicalDeviceLimits.nmaxTessellationControlTotalOutputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationEvaluationInputComponents() {
            return VkPhysicalDeviceLimits.nmaxTessellationEvaluationInputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTessellationEvaluationOutputComponents() {
            return VkPhysicalDeviceLimits.nmaxTessellationEvaluationOutputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxGeometryShaderInvocations() {
            return VkPhysicalDeviceLimits.nmaxGeometryShaderInvocations(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxGeometryInputComponents() {
            return VkPhysicalDeviceLimits.nmaxGeometryInputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxGeometryOutputComponents() {
            return VkPhysicalDeviceLimits.nmaxGeometryOutputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxGeometryOutputVertices() {
            return VkPhysicalDeviceLimits.nmaxGeometryOutputVertices(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxGeometryTotalOutputComponents() {
            return VkPhysicalDeviceLimits.nmaxGeometryTotalOutputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFragmentInputComponents() {
            return VkPhysicalDeviceLimits.nmaxFragmentInputComponents(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFragmentOutputAttachments() {
            return VkPhysicalDeviceLimits.nmaxFragmentOutputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFragmentDualSrcAttachments() {
            return VkPhysicalDeviceLimits.nmaxFragmentDualSrcAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFragmentCombinedOutputResources() {
            return VkPhysicalDeviceLimits.nmaxFragmentCombinedOutputResources(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxComputeSharedMemorySize() {
            return VkPhysicalDeviceLimits.nmaxComputeSharedMemorySize(this.address());
        }

        @NativeType(value="uint32_t[3]")
        public IntBuffer maxComputeWorkGroupCount() {
            return VkPhysicalDeviceLimits.nmaxComputeWorkGroupCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxComputeWorkGroupCount(int index) {
            return VkPhysicalDeviceLimits.nmaxComputeWorkGroupCount(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int maxComputeWorkGroupInvocations() {
            return VkPhysicalDeviceLimits.nmaxComputeWorkGroupInvocations(this.address());
        }

        @NativeType(value="uint32_t[3]")
        public IntBuffer maxComputeWorkGroupSize() {
            return VkPhysicalDeviceLimits.nmaxComputeWorkGroupSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxComputeWorkGroupSize(int index) {
            return VkPhysicalDeviceLimits.nmaxComputeWorkGroupSize(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int subPixelPrecisionBits() {
            return VkPhysicalDeviceLimits.nsubPixelPrecisionBits(this.address());
        }

        @NativeType(value="uint32_t")
        public int subTexelPrecisionBits() {
            return VkPhysicalDeviceLimits.nsubTexelPrecisionBits(this.address());
        }

        @NativeType(value="uint32_t")
        public int mipmapPrecisionBits() {
            return VkPhysicalDeviceLimits.nmipmapPrecisionBits(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDrawIndexedIndexValue() {
            return VkPhysicalDeviceLimits.nmaxDrawIndexedIndexValue(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDrawIndirectCount() {
            return VkPhysicalDeviceLimits.nmaxDrawIndirectCount(this.address());
        }

        public float maxSamplerLodBias() {
            return VkPhysicalDeviceLimits.nmaxSamplerLodBias(this.address());
        }

        public float maxSamplerAnisotropy() {
            return VkPhysicalDeviceLimits.nmaxSamplerAnisotropy(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxViewports() {
            return VkPhysicalDeviceLimits.nmaxViewports(this.address());
        }

        @NativeType(value="uint32_t[2]")
        public IntBuffer maxViewportDimensions() {
            return VkPhysicalDeviceLimits.nmaxViewportDimensions(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxViewportDimensions(int index) {
            return VkPhysicalDeviceLimits.nmaxViewportDimensions(this.address(), index);
        }

        @NativeType(value="float[2]")
        public FloatBuffer viewportBoundsRange() {
            return VkPhysicalDeviceLimits.nviewportBoundsRange(this.address());
        }

        public float viewportBoundsRange(int index) {
            return VkPhysicalDeviceLimits.nviewportBoundsRange(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int viewportSubPixelBits() {
            return VkPhysicalDeviceLimits.nviewportSubPixelBits(this.address());
        }

        @NativeType(value="size_t")
        public long minMemoryMapAlignment() {
            return VkPhysicalDeviceLimits.nminMemoryMapAlignment(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minTexelBufferOffsetAlignment() {
            return VkPhysicalDeviceLimits.nminTexelBufferOffsetAlignment(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minUniformBufferOffsetAlignment() {
            return VkPhysicalDeviceLimits.nminUniformBufferOffsetAlignment(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minStorageBufferOffsetAlignment() {
            return VkPhysicalDeviceLimits.nminStorageBufferOffsetAlignment(this.address());
        }

        @NativeType(value="int32_t")
        public int minTexelOffset() {
            return VkPhysicalDeviceLimits.nminTexelOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTexelOffset() {
            return VkPhysicalDeviceLimits.nmaxTexelOffset(this.address());
        }

        @NativeType(value="int32_t")
        public int minTexelGatherOffset() {
            return VkPhysicalDeviceLimits.nminTexelGatherOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTexelGatherOffset() {
            return VkPhysicalDeviceLimits.nmaxTexelGatherOffset(this.address());
        }

        public float minInterpolationOffset() {
            return VkPhysicalDeviceLimits.nminInterpolationOffset(this.address());
        }

        public float maxInterpolationOffset() {
            return VkPhysicalDeviceLimits.nmaxInterpolationOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int subPixelInterpolationOffsetBits() {
            return VkPhysicalDeviceLimits.nsubPixelInterpolationOffsetBits(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFramebufferWidth() {
            return VkPhysicalDeviceLimits.nmaxFramebufferWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFramebufferHeight() {
            return VkPhysicalDeviceLimits.nmaxFramebufferHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFramebufferLayers() {
            return VkPhysicalDeviceLimits.nmaxFramebufferLayers(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int framebufferColorSampleCounts() {
            return VkPhysicalDeviceLimits.nframebufferColorSampleCounts(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int framebufferDepthSampleCounts() {
            return VkPhysicalDeviceLimits.nframebufferDepthSampleCounts(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int framebufferStencilSampleCounts() {
            return VkPhysicalDeviceLimits.nframebufferStencilSampleCounts(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int framebufferNoAttachmentsSampleCounts() {
            return VkPhysicalDeviceLimits.nframebufferNoAttachmentsSampleCounts(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxColorAttachments() {
            return VkPhysicalDeviceLimits.nmaxColorAttachments(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampledImageColorSampleCounts() {
            return VkPhysicalDeviceLimits.nsampledImageColorSampleCounts(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampledImageIntegerSampleCounts() {
            return VkPhysicalDeviceLimits.nsampledImageIntegerSampleCounts(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampledImageDepthSampleCounts() {
            return VkPhysicalDeviceLimits.nsampledImageDepthSampleCounts(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampledImageStencilSampleCounts() {
            return VkPhysicalDeviceLimits.nsampledImageStencilSampleCounts(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int storageImageSampleCounts() {
            return VkPhysicalDeviceLimits.nstorageImageSampleCounts(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxSampleMaskWords() {
            return VkPhysicalDeviceLimits.nmaxSampleMaskWords(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean timestampComputeAndGraphics() {
            return VkPhysicalDeviceLimits.ntimestampComputeAndGraphics(this.address()) != 0;
        }

        public float timestampPeriod() {
            return VkPhysicalDeviceLimits.ntimestampPeriod(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxClipDistances() {
            return VkPhysicalDeviceLimits.nmaxClipDistances(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxCullDistances() {
            return VkPhysicalDeviceLimits.nmaxCullDistances(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxCombinedClipAndCullDistances() {
            return VkPhysicalDeviceLimits.nmaxCombinedClipAndCullDistances(this.address());
        }

        @NativeType(value="uint32_t")
        public int discreteQueuePriorities() {
            return VkPhysicalDeviceLimits.ndiscreteQueuePriorities(this.address());
        }

        @NativeType(value="float[2]")
        public FloatBuffer pointSizeRange() {
            return VkPhysicalDeviceLimits.npointSizeRange(this.address());
        }

        public float pointSizeRange(int index) {
            return VkPhysicalDeviceLimits.npointSizeRange(this.address(), index);
        }

        @NativeType(value="float[2]")
        public FloatBuffer lineWidthRange() {
            return VkPhysicalDeviceLimits.nlineWidthRange(this.address());
        }

        public float lineWidthRange(int index) {
            return VkPhysicalDeviceLimits.nlineWidthRange(this.address(), index);
        }

        public float pointSizeGranularity() {
            return VkPhysicalDeviceLimits.npointSizeGranularity(this.address());
        }

        public float lineWidthGranularity() {
            return VkPhysicalDeviceLimits.nlineWidthGranularity(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean strictLines() {
            return VkPhysicalDeviceLimits.nstrictLines(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean standardSampleLocations() {
            return VkPhysicalDeviceLimits.nstandardSampleLocations(this.address()) != 0;
        }

        @NativeType(value="VkDeviceSize")
        public long optimalBufferCopyOffsetAlignment() {
            return VkPhysicalDeviceLimits.noptimalBufferCopyOffsetAlignment(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long optimalBufferCopyRowPitchAlignment() {
            return VkPhysicalDeviceLimits.noptimalBufferCopyRowPitchAlignment(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long nonCoherentAtomSize() {
            return VkPhysicalDeviceLimits.nnonCoherentAtomSize(this.address());
        }
    }
}

