/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkObjectTableEntryNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;

    VkObjectTableEntryNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkObjectTableEntryNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkObjectTableEntryNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkObjectEntryTypeNVX")
    public int type() {
        return VkObjectTableEntryNVX.ntype(this.address());
    }

    @NativeType(value="VkObjectEntryUsageFlagsNVX")
    public int flags() {
        return VkObjectTableEntryNVX.nflags(this.address());
    }

    public VkObjectTableEntryNVX type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
        VkObjectTableEntryNVX.ntype(this.address(), value);
        return this;
    }

    public VkObjectTableEntryNVX flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
        VkObjectTableEntryNVX.nflags(this.address(), value);
        return this;
    }

    public VkObjectTableEntryNVX set(int type, int flags) {
        this.type(type);
        this.flags(flags);
        return this;
    }

    public VkObjectTableEntryNVX set(VkObjectTableEntryNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkObjectTableEntryNVX malloc() {
        return VkObjectTableEntryNVX.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkObjectTableEntryNVX calloc() {
        return VkObjectTableEntryNVX.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkObjectTableEntryNVX create() {
        return new VkObjectTableEntryNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkObjectTableEntryNVX create(long address) {
        return new VkObjectTableEntryNVX(address, null);
    }

    @Nullable
    public static VkObjectTableEntryNVX createSafe(long address) {
        return address == 0L ? null : VkObjectTableEntryNVX.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkObjectTableEntryNVX.create(VkObjectTableEntryNVX.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkObjectTableEntryNVX.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkObjectTableEntryNVX.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkObjectTableEntryNVX.create(address, capacity);
    }

    public static VkObjectTableEntryNVX mallocStack() {
        return VkObjectTableEntryNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableEntryNVX callocStack() {
        return VkObjectTableEntryNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableEntryNVX mallocStack(MemoryStack stack) {
        return VkObjectTableEntryNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkObjectTableEntryNVX callocStack(MemoryStack stack) {
        return VkObjectTableEntryNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkObjectTableEntryNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkObjectTableEntryNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkObjectTableEntryNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkObjectTableEntryNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkObjectTableEntryNVX.__struct(VkObjectTableEntryNVX.__member(4), VkObjectTableEntryNVX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkObjectTableEntryNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkObjectTableEntryNVX newInstance(long address) {
            return new VkObjectTableEntryNVX(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkObjectEntryTypeNVX")
        public int type() {
            return VkObjectTableEntryNVX.ntype(this.address());
        }

        @NativeType(value="VkObjectEntryUsageFlagsNVX")
        public int flags() {
            return VkObjectTableEntryNVX.nflags(this.address());
        }

        public Buffer type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
            VkObjectTableEntryNVX.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
            VkObjectTableEntryNVX.nflags(this.address(), value);
            return this;
        }
    }
}

