/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkObjectTableCreateInfoNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTCOUNT;
    public static final int POBJECTENTRYTYPES;
    public static final int POBJECTENTRYCOUNTS;
    public static final int POBJECTENTRYUSAGEFLAGS;
    public static final int MAXUNIFORMBUFFERSPERDESCRIPTOR;
    public static final int MAXSTORAGEBUFFERSPERDESCRIPTOR;
    public static final int MAXSTORAGEIMAGESPERDESCRIPTOR;
    public static final int MAXSAMPLEDIMAGESPERDESCRIPTOR;
    public static final int MAXPIPELINELAYOUTS;

    VkObjectTableCreateInfoNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkObjectTableCreateInfoNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkObjectTableCreateInfoNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkObjectTableCreateInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkObjectTableCreateInfoNVX.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int objectCount() {
        return VkObjectTableCreateInfoNVX.nobjectCount(this.address());
    }

    @NativeType(value="VkObjectEntryTypeNVX const *")
    public IntBuffer pObjectEntryTypes() {
        return VkObjectTableCreateInfoNVX.npObjectEntryTypes(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pObjectEntryCounts() {
        return VkObjectTableCreateInfoNVX.npObjectEntryCounts(this.address());
    }

    @NativeType(value="VkObjectEntryUsageFlagsNVX const *")
    public IntBuffer pObjectEntryUsageFlags() {
        return VkObjectTableCreateInfoNVX.npObjectEntryUsageFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxUniformBuffersPerDescriptor() {
        return VkObjectTableCreateInfoNVX.nmaxUniformBuffersPerDescriptor(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxStorageBuffersPerDescriptor() {
        return VkObjectTableCreateInfoNVX.nmaxStorageBuffersPerDescriptor(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxStorageImagesPerDescriptor() {
        return VkObjectTableCreateInfoNVX.nmaxStorageImagesPerDescriptor(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxSampledImagesPerDescriptor() {
        return VkObjectTableCreateInfoNVX.nmaxSampledImagesPerDescriptor(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPipelineLayouts() {
        return VkObjectTableCreateInfoNVX.nmaxPipelineLayouts(this.address());
    }

    public VkObjectTableCreateInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkObjectTableCreateInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkObjectTableCreateInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX objectCount(@NativeType(value="uint32_t") int value) {
        VkObjectTableCreateInfoNVX.nobjectCount(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX pObjectEntryTypes(@NativeType(value="VkObjectEntryTypeNVX const *") IntBuffer value) {
        VkObjectTableCreateInfoNVX.npObjectEntryTypes(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX pObjectEntryCounts(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkObjectTableCreateInfoNVX.npObjectEntryCounts(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX pObjectEntryUsageFlags(@NativeType(value="VkObjectEntryUsageFlagsNVX const *") IntBuffer value) {
        VkObjectTableCreateInfoNVX.npObjectEntryUsageFlags(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX maxUniformBuffersPerDescriptor(@NativeType(value="uint32_t") int value) {
        VkObjectTableCreateInfoNVX.nmaxUniformBuffersPerDescriptor(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX maxStorageBuffersPerDescriptor(@NativeType(value="uint32_t") int value) {
        VkObjectTableCreateInfoNVX.nmaxStorageBuffersPerDescriptor(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX maxStorageImagesPerDescriptor(@NativeType(value="uint32_t") int value) {
        VkObjectTableCreateInfoNVX.nmaxStorageImagesPerDescriptor(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX maxSampledImagesPerDescriptor(@NativeType(value="uint32_t") int value) {
        VkObjectTableCreateInfoNVX.nmaxSampledImagesPerDescriptor(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX maxPipelineLayouts(@NativeType(value="uint32_t") int value) {
        VkObjectTableCreateInfoNVX.nmaxPipelineLayouts(this.address(), value);
        return this;
    }

    public VkObjectTableCreateInfoNVX set(int sType, long pNext, int objectCount, IntBuffer pObjectEntryTypes, IntBuffer pObjectEntryCounts, IntBuffer pObjectEntryUsageFlags, int maxUniformBuffersPerDescriptor, int maxStorageBuffersPerDescriptor, int maxStorageImagesPerDescriptor, int maxSampledImagesPerDescriptor, int maxPipelineLayouts) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectCount(objectCount);
        this.pObjectEntryTypes(pObjectEntryTypes);
        this.pObjectEntryCounts(pObjectEntryCounts);
        this.pObjectEntryUsageFlags(pObjectEntryUsageFlags);
        this.maxUniformBuffersPerDescriptor(maxUniformBuffersPerDescriptor);
        this.maxStorageBuffersPerDescriptor(maxStorageBuffersPerDescriptor);
        this.maxStorageImagesPerDescriptor(maxStorageImagesPerDescriptor);
        this.maxSampledImagesPerDescriptor(maxSampledImagesPerDescriptor);
        this.maxPipelineLayouts(maxPipelineLayouts);
        return this;
    }

    public VkObjectTableCreateInfoNVX set(VkObjectTableCreateInfoNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkObjectTableCreateInfoNVX malloc() {
        return VkObjectTableCreateInfoNVX.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkObjectTableCreateInfoNVX calloc() {
        return VkObjectTableCreateInfoNVX.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkObjectTableCreateInfoNVX create() {
        return new VkObjectTableCreateInfoNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkObjectTableCreateInfoNVX create(long address) {
        return new VkObjectTableCreateInfoNVX(address, null);
    }

    @Nullable
    public static VkObjectTableCreateInfoNVX createSafe(long address) {
        return address == 0L ? null : VkObjectTableCreateInfoNVX.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkObjectTableCreateInfoNVX.create(VkObjectTableCreateInfoNVX.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkObjectTableCreateInfoNVX.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkObjectTableCreateInfoNVX.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkObjectTableCreateInfoNVX.create(address, capacity);
    }

    public static VkObjectTableCreateInfoNVX mallocStack() {
        return VkObjectTableCreateInfoNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableCreateInfoNVX callocStack() {
        return VkObjectTableCreateInfoNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableCreateInfoNVX mallocStack(MemoryStack stack) {
        return VkObjectTableCreateInfoNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkObjectTableCreateInfoNVX callocStack(MemoryStack stack) {
        return VkObjectTableCreateInfoNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkObjectTableCreateInfoNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkObjectTableCreateInfoNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkObjectTableCreateInfoNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkObjectTableCreateInfoNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nobjectCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OBJECTCOUNT);
    }

    public static IntBuffer npObjectEntryTypes(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)POBJECTENTRYTYPES), VkObjectTableCreateInfoNVX.nobjectCount(struct));
    }

    public static IntBuffer npObjectEntryCounts(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)POBJECTENTRYCOUNTS), VkObjectTableCreateInfoNVX.nobjectCount(struct));
    }

    public static IntBuffer npObjectEntryUsageFlags(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)POBJECTENTRYUSAGEFLAGS), VkObjectTableCreateInfoNVX.nobjectCount(struct));
    }

    public static int nmaxUniformBuffersPerDescriptor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXUNIFORMBUFFERSPERDESCRIPTOR);
    }

    public static int nmaxStorageBuffersPerDescriptor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSTORAGEBUFFERSPERDESCRIPTOR);
    }

    public static int nmaxStorageImagesPerDescriptor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSTORAGEIMAGESPERDESCRIPTOR);
    }

    public static int nmaxSampledImagesPerDescriptor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSAMPLEDIMAGESPERDESCRIPTOR);
    }

    public static int nmaxPipelineLayouts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPIPELINELAYOUTS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nobjectCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OBJECTCOUNT, value);
    }

    public static void npObjectEntryTypes(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)POBJECTENTRYTYPES, MemoryUtil.memAddress(value));
    }

    public static void npObjectEntryCounts(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)POBJECTENTRYCOUNTS, MemoryUtil.memAddress(value));
    }

    public static void npObjectEntryUsageFlags(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)POBJECTENTRYUSAGEFLAGS, MemoryUtil.memAddress(value));
    }

    public static void nmaxUniformBuffersPerDescriptor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXUNIFORMBUFFERSPERDESCRIPTOR, value);
    }

    public static void nmaxStorageBuffersPerDescriptor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXSTORAGEBUFFERSPERDESCRIPTOR, value);
    }

    public static void nmaxStorageImagesPerDescriptor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXSTORAGEIMAGESPERDESCRIPTOR, value);
    }

    public static void nmaxSampledImagesPerDescriptor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXSAMPLEDIMAGESPERDESCRIPTOR, value);
    }

    public static void nmaxPipelineLayouts(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXPIPELINELAYOUTS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POBJECTENTRYTYPES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POBJECTENTRYCOUNTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POBJECTENTRYUSAGEFLAGS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkObjectTableCreateInfoNVX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkObjectTableCreateInfoNVX.__struct(VkObjectTableCreateInfoNVX.__member(4), VkObjectTableCreateInfoNVX.__member(POINTER_SIZE), VkObjectTableCreateInfoNVX.__member(4), VkObjectTableCreateInfoNVX.__member(POINTER_SIZE), VkObjectTableCreateInfoNVX.__member(POINTER_SIZE), VkObjectTableCreateInfoNVX.__member(POINTER_SIZE), VkObjectTableCreateInfoNVX.__member(4), VkObjectTableCreateInfoNVX.__member(4), VkObjectTableCreateInfoNVX.__member(4), VkObjectTableCreateInfoNVX.__member(4), VkObjectTableCreateInfoNVX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTCOUNT = layout.offsetof(2);
        POBJECTENTRYTYPES = layout.offsetof(3);
        POBJECTENTRYCOUNTS = layout.offsetof(4);
        POBJECTENTRYUSAGEFLAGS = layout.offsetof(5);
        MAXUNIFORMBUFFERSPERDESCRIPTOR = layout.offsetof(6);
        MAXSTORAGEBUFFERSPERDESCRIPTOR = layout.offsetof(7);
        MAXSTORAGEIMAGESPERDESCRIPTOR = layout.offsetof(8);
        MAXSAMPLEDIMAGESPERDESCRIPTOR = layout.offsetof(9);
        MAXPIPELINELAYOUTS = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkObjectTableCreateInfoNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkObjectTableCreateInfoNVX newInstance(long address) {
            return new VkObjectTableCreateInfoNVX(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkObjectTableCreateInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkObjectTableCreateInfoNVX.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int objectCount() {
            return VkObjectTableCreateInfoNVX.nobjectCount(this.address());
        }

        @NativeType(value="VkObjectEntryTypeNVX const *")
        public IntBuffer pObjectEntryTypes() {
            return VkObjectTableCreateInfoNVX.npObjectEntryTypes(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pObjectEntryCounts() {
            return VkObjectTableCreateInfoNVX.npObjectEntryCounts(this.address());
        }

        @NativeType(value="VkObjectEntryUsageFlagsNVX const *")
        public IntBuffer pObjectEntryUsageFlags() {
            return VkObjectTableCreateInfoNVX.npObjectEntryUsageFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxUniformBuffersPerDescriptor() {
            return VkObjectTableCreateInfoNVX.nmaxUniformBuffersPerDescriptor(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxStorageBuffersPerDescriptor() {
            return VkObjectTableCreateInfoNVX.nmaxStorageBuffersPerDescriptor(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxStorageImagesPerDescriptor() {
            return VkObjectTableCreateInfoNVX.nmaxStorageImagesPerDescriptor(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxSampledImagesPerDescriptor() {
            return VkObjectTableCreateInfoNVX.nmaxSampledImagesPerDescriptor(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPipelineLayouts() {
            return VkObjectTableCreateInfoNVX.nmaxPipelineLayouts(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkObjectTableCreateInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkObjectTableCreateInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer objectCount(@NativeType(value="uint32_t") int value) {
            VkObjectTableCreateInfoNVX.nobjectCount(this.address(), value);
            return this;
        }

        public Buffer pObjectEntryTypes(@NativeType(value="VkObjectEntryTypeNVX const *") IntBuffer value) {
            VkObjectTableCreateInfoNVX.npObjectEntryTypes(this.address(), value);
            return this;
        }

        public Buffer pObjectEntryCounts(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkObjectTableCreateInfoNVX.npObjectEntryCounts(this.address(), value);
            return this;
        }

        public Buffer pObjectEntryUsageFlags(@NativeType(value="VkObjectEntryUsageFlagsNVX const *") IntBuffer value) {
            VkObjectTableCreateInfoNVX.npObjectEntryUsageFlags(this.address(), value);
            return this;
        }

        public Buffer maxUniformBuffersPerDescriptor(@NativeType(value="uint32_t") int value) {
            VkObjectTableCreateInfoNVX.nmaxUniformBuffersPerDescriptor(this.address(), value);
            return this;
        }

        public Buffer maxStorageBuffersPerDescriptor(@NativeType(value="uint32_t") int value) {
            VkObjectTableCreateInfoNVX.nmaxStorageBuffersPerDescriptor(this.address(), value);
            return this;
        }

        public Buffer maxStorageImagesPerDescriptor(@NativeType(value="uint32_t") int value) {
            VkObjectTableCreateInfoNVX.nmaxStorageImagesPerDescriptor(this.address(), value);
            return this;
        }

        public Buffer maxSampledImagesPerDescriptor(@NativeType(value="uint32_t") int value) {
            VkObjectTableCreateInfoNVX.nmaxSampledImagesPerDescriptor(this.address(), value);
            return this;
        }

        public Buffer maxPipelineLayouts(@NativeType(value="uint32_t") int value) {
            VkObjectTableCreateInfoNVX.nmaxPipelineLayouts(this.address(), value);
            return this;
        }
    }
}

