/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkMultisamplePropertiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MAXSAMPLELOCATIONGRIDSIZE;

    VkMultisamplePropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMultisamplePropertiesEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMultisamplePropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMultisamplePropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMultisamplePropertiesEXT.npNext(this.address());
    }

    public VkExtent2D maxSampleLocationGridSize() {
        return VkMultisamplePropertiesEXT.nmaxSampleLocationGridSize(this.address());
    }

    public VkMultisamplePropertiesEXT maxSampleLocationGridSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxSampleLocationGridSize());
        return this;
    }

    public VkMultisamplePropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMultisamplePropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkMultisamplePropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkMultisamplePropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkMultisamplePropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMultisamplePropertiesEXT set(VkMultisamplePropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMultisamplePropertiesEXT malloc() {
        return VkMultisamplePropertiesEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMultisamplePropertiesEXT calloc() {
        return VkMultisamplePropertiesEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMultisamplePropertiesEXT create() {
        return new VkMultisamplePropertiesEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMultisamplePropertiesEXT create(long address) {
        return new VkMultisamplePropertiesEXT(address, null);
    }

    @Nullable
    public static VkMultisamplePropertiesEXT createSafe(long address) {
        return address == 0L ? null : VkMultisamplePropertiesEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMultisamplePropertiesEXT.create(VkMultisamplePropertiesEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMultisamplePropertiesEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMultisamplePropertiesEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMultisamplePropertiesEXT.create(address, capacity);
    }

    public static VkMultisamplePropertiesEXT mallocStack() {
        return VkMultisamplePropertiesEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkMultisamplePropertiesEXT callocStack() {
        return VkMultisamplePropertiesEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkMultisamplePropertiesEXT mallocStack(MemoryStack stack) {
        return VkMultisamplePropertiesEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMultisamplePropertiesEXT callocStack(MemoryStack stack) {
        return VkMultisamplePropertiesEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMultisamplePropertiesEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMultisamplePropertiesEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMultisamplePropertiesEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMultisamplePropertiesEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkExtent2D nmaxSampleLocationGridSize(long struct) {
        return VkExtent2D.create(struct + (long)MAXSAMPLELOCATIONGRIDSIZE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkMultisamplePropertiesEXT.__struct(VkMultisamplePropertiesEXT.__member(4), VkMultisamplePropertiesEXT.__member(POINTER_SIZE), VkMultisamplePropertiesEXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MAXSAMPLELOCATIONGRIDSIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMultisamplePropertiesEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMultisamplePropertiesEXT newInstance(long address) {
            return new VkMultisamplePropertiesEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMultisamplePropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMultisamplePropertiesEXT.npNext(this.address());
        }

        public VkExtent2D maxSampleLocationGridSize() {
            return VkMultisamplePropertiesEXT.nmaxSampleLocationGridSize(this.address());
        }

        public Buffer maxSampleLocationGridSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxSampleLocationGridSize());
            return this;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMultisamplePropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMultisamplePropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

