/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryRequirements;

public class VkMemoryRequirements2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYREQUIREMENTS;

    VkMemoryRequirements2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryRequirements2(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryRequirements2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryRequirements2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryRequirements2.npNext(this.address());
    }

    public VkMemoryRequirements memoryRequirements() {
        return VkMemoryRequirements2.nmemoryRequirements(this.address());
    }

    public VkMemoryRequirements2 sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryRequirements2.nsType(this.address(), value);
        return this;
    }

    public VkMemoryRequirements2 pNext(@NativeType(value="void *") long value) {
        VkMemoryRequirements2.npNext(this.address(), value);
        return this;
    }

    public VkMemoryRequirements2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryRequirements2 set(VkMemoryRequirements2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryRequirements2 malloc() {
        return VkMemoryRequirements2.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryRequirements2 calloc() {
        return VkMemoryRequirements2.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryRequirements2 create() {
        return new VkMemoryRequirements2(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryRequirements2 create(long address) {
        return new VkMemoryRequirements2(address, null);
    }

    @Nullable
    public static VkMemoryRequirements2 createSafe(long address) {
        return address == 0L ? null : VkMemoryRequirements2.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryRequirements2.create(VkMemoryRequirements2.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryRequirements2.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryRequirements2.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryRequirements2.create(address, capacity);
    }

    public static VkMemoryRequirements2 mallocStack() {
        return VkMemoryRequirements2.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryRequirements2 callocStack() {
        return VkMemoryRequirements2.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryRequirements2 mallocStack(MemoryStack stack) {
        return VkMemoryRequirements2.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryRequirements2 callocStack(MemoryStack stack) {
        return VkMemoryRequirements2.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkMemoryRequirements nmemoryRequirements(long struct) {
        return VkMemoryRequirements.create(struct + (long)MEMORYREQUIREMENTS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkMemoryRequirements2.__struct(VkMemoryRequirements2.__member(4), VkMemoryRequirements2.__member(POINTER_SIZE), VkMemoryRequirements2.__member(VkMemoryRequirements.SIZEOF, VkMemoryRequirements.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYREQUIREMENTS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryRequirements2, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryRequirements2 newInstance(long address) {
            return new VkMemoryRequirements2(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryRequirements2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryRequirements2.npNext(this.address());
        }

        public VkMemoryRequirements memoryRequirements() {
            return VkMemoryRequirements2.nmemoryRequirements(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryRequirements2.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryRequirements2.npNext(this.address(), value);
            return this;
        }
    }
}

