/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryGetWin32HandleInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;
    public static final int HANDLETYPE;

    VkMemoryGetWin32HandleInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryGetWin32HandleInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryGetWin32HandleInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryGetWin32HandleInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryGetWin32HandleInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryGetWin32HandleInfoKHR.nmemory(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkMemoryGetWin32HandleInfoKHR.nhandleType(this.address());
    }

    public VkMemoryGetWin32HandleInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryGetWin32HandleInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkMemoryGetWin32HandleInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryGetWin32HandleInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkMemoryGetWin32HandleInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryGetWin32HandleInfoKHR.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryGetWin32HandleInfoKHR handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkMemoryGetWin32HandleInfoKHR.nhandleType(this.address(), value);
        return this;
    }

    public VkMemoryGetWin32HandleInfoKHR set(int sType, long pNext, long memory, int handleType) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        this.handleType(handleType);
        return this;
    }

    public VkMemoryGetWin32HandleInfoKHR set(VkMemoryGetWin32HandleInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryGetWin32HandleInfoKHR malloc() {
        return VkMemoryGetWin32HandleInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryGetWin32HandleInfoKHR calloc() {
        return VkMemoryGetWin32HandleInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryGetWin32HandleInfoKHR create() {
        return new VkMemoryGetWin32HandleInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryGetWin32HandleInfoKHR create(long address) {
        return new VkMemoryGetWin32HandleInfoKHR(address, null);
    }

    @Nullable
    public static VkMemoryGetWin32HandleInfoKHR createSafe(long address) {
        return address == 0L ? null : VkMemoryGetWin32HandleInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryGetWin32HandleInfoKHR.create(VkMemoryGetWin32HandleInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryGetWin32HandleInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryGetWin32HandleInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryGetWin32HandleInfoKHR.create(address, capacity);
    }

    public static VkMemoryGetWin32HandleInfoKHR mallocStack() {
        return VkMemoryGetWin32HandleInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryGetWin32HandleInfoKHR callocStack() {
        return VkMemoryGetWin32HandleInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryGetWin32HandleInfoKHR mallocStack(MemoryStack stack) {
        return VkMemoryGetWin32HandleInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryGetWin32HandleInfoKHR callocStack(MemoryStack stack) {
        return VkMemoryGetWin32HandleInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryGetWin32HandleInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryGetWin32HandleInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryGetWin32HandleInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryGetWin32HandleInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static int nhandleType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void nhandleType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPE, value);
    }

    static {
        Struct.Layout layout = VkMemoryGetWin32HandleInfoKHR.__struct(VkMemoryGetWin32HandleInfoKHR.__member(4), VkMemoryGetWin32HandleInfoKHR.__member(POINTER_SIZE), VkMemoryGetWin32HandleInfoKHR.__member(8), VkMemoryGetWin32HandleInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        HANDLETYPE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryGetWin32HandleInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryGetWin32HandleInfoKHR newInstance(long address) {
            return new VkMemoryGetWin32HandleInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryGetWin32HandleInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryGetWin32HandleInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryGetWin32HandleInfoKHR.nmemory(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkMemoryGetWin32HandleInfoKHR.nhandleType(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryGetWin32HandleInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryGetWin32HandleInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryGetWin32HandleInfoKHR.nmemory(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkMemoryGetWin32HandleInfoKHR.nhandleType(this.address(), value);
            return this;
        }
    }
}

