/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryDedicatedAllocateInfo;

public class VkMemoryDedicatedAllocateInfoKHR
extends VkMemoryDedicatedAllocateInfo {
    VkMemoryDedicatedAllocateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryDedicatedAllocateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryDedicatedAllocateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedAllocateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryDedicatedAllocateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR image(@NativeType(value="VkImage") long value) {
        VkMemoryDedicatedAllocateInfoKHR.nimage(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkMemoryDedicatedAllocateInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR set(int sType, long pNext, long image, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.buffer(buffer);
        return this;
    }

    public VkMemoryDedicatedAllocateInfoKHR set(VkMemoryDedicatedAllocateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedAllocateInfoKHR malloc() {
        return VkMemoryDedicatedAllocateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfoKHR calloc() {
        return VkMemoryDedicatedAllocateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfoKHR create() {
        return new VkMemoryDedicatedAllocateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfoKHR create(long address) {
        return new VkMemoryDedicatedAllocateInfoKHR(address, null);
    }

    @Nullable
    public static VkMemoryDedicatedAllocateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkMemoryDedicatedAllocateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.create(VkMemoryDedicatedAllocateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryDedicatedAllocateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryDedicatedAllocateInfoKHR.create(address, capacity);
    }

    public static VkMemoryDedicatedAllocateInfoKHR mallocStack() {
        return VkMemoryDedicatedAllocateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryDedicatedAllocateInfoKHR callocStack() {
        return VkMemoryDedicatedAllocateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryDedicatedAllocateInfoKHR mallocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfoKHR callocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryDedicatedAllocateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryDedicatedAllocateInfoKHR newInstance(long address) {
            return new VkMemoryDedicatedAllocateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedAllocateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryDedicatedAllocateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer image(@NativeType(value="VkImage") long value) {
            VkMemoryDedicatedAllocateInfoKHR.nimage(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkMemoryDedicatedAllocateInfoKHR.nbuffer(this.address(), value);
            return this;
        }
    }
}

