/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryDedicatedAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;
    public static final int BUFFER;

    VkMemoryDedicatedAllocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryDedicatedAllocateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryDedicatedAllocateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryDedicatedAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryDedicatedAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkMemoryDedicatedAllocateInfo.nimage(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkMemoryDedicatedAllocateInfo.nbuffer(this.address());
    }

    public VkMemoryDedicatedAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryDedicatedAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo image(@NativeType(value="VkImage") long value) {
        VkMemoryDedicatedAllocateInfo.nimage(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkMemoryDedicatedAllocateInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo set(int sType, long pNext, long image, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.buffer(buffer);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo set(VkMemoryDedicatedAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedAllocateInfo malloc() {
        return VkMemoryDedicatedAllocateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfo calloc() {
        return VkMemoryDedicatedAllocateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfo create() {
        return new VkMemoryDedicatedAllocateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfo create(long address) {
        return new VkMemoryDedicatedAllocateInfo(address, null);
    }

    @Nullable
    public static VkMemoryDedicatedAllocateInfo createSafe(long address) {
        return address == 0L ? null : VkMemoryDedicatedAllocateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryDedicatedAllocateInfo.create(VkMemoryDedicatedAllocateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryDedicatedAllocateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryDedicatedAllocateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryDedicatedAllocateInfo.create(address, capacity);
    }

    public static VkMemoryDedicatedAllocateInfo mallocStack() {
        return VkMemoryDedicatedAllocateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryDedicatedAllocateInfo callocStack() {
        return VkMemoryDedicatedAllocateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryDedicatedAllocateInfo mallocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfo callocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    static {
        Struct.Layout layout = VkMemoryDedicatedAllocateInfo.__struct(VkMemoryDedicatedAllocateInfo.__member(4), VkMemoryDedicatedAllocateInfo.__member(POINTER_SIZE), VkMemoryDedicatedAllocateInfo.__member(8), VkMemoryDedicatedAllocateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryDedicatedAllocateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryDedicatedAllocateInfo newInstance(long address) {
            return new VkMemoryDedicatedAllocateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryDedicatedAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryDedicatedAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkMemoryDedicatedAllocateInfo.nimage(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkMemoryDedicatedAllocateInfo.nbuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryDedicatedAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkMemoryDedicatedAllocateInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkMemoryDedicatedAllocateInfo.nbuffer(this.address(), value);
            return this;
        }
    }
}

