/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryAllocateFlagsInfo;

public class VkMemoryAllocateFlagsInfoKHR
extends VkMemoryAllocateFlagsInfo {
    VkMemoryAllocateFlagsInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryAllocateFlagsInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryAllocateFlagsInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateFlagsInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateFlagsInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
        VkMemoryAllocateFlagsInfoKHR.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR deviceMask(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateFlagsInfoKHR.ndeviceMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHR set(VkMemoryAllocateFlagsInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfoKHR malloc() {
        return VkMemoryAllocateFlagsInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHR calloc() {
        return VkMemoryAllocateFlagsInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHR create() {
        return new VkMemoryAllocateFlagsInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHR create(long address) {
        return new VkMemoryAllocateFlagsInfoKHR(address, null);
    }

    @Nullable
    public static VkMemoryAllocateFlagsInfoKHR createSafe(long address) {
        return address == 0L ? null : VkMemoryAllocateFlagsInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.create(VkMemoryAllocateFlagsInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryAllocateFlagsInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryAllocateFlagsInfoKHR.create(address, capacity);
    }

    public static VkMemoryAllocateFlagsInfoKHR mallocStack() {
        return VkMemoryAllocateFlagsInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfoKHR callocStack() {
        return VkMemoryAllocateFlagsInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfoKHR mallocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHR callocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryAllocateFlagsInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryAllocateFlagsInfoKHR newInstance(long address) {
            return new VkMemoryAllocateFlagsInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateFlagsInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateFlagsInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
            VkMemoryAllocateFlagsInfoKHR.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateFlagsInfoKHR.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

