/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryAllocateFlagsInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DEVICEMASK;

    VkMemoryAllocateFlagsInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryAllocateFlagsInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryAllocateFlagsInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryAllocateFlagsInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryAllocateFlagsInfo.npNext(this.address());
    }

    @NativeType(value="VkMemoryAllocateFlags")
    public int flags() {
        return VkMemoryAllocateFlagsInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
    }

    public VkMemoryAllocateFlagsInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
        VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(VkMemoryAllocateFlagsInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfo malloc() {
        return VkMemoryAllocateFlagsInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo calloc() {
        return VkMemoryAllocateFlagsInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo create() {
        return new VkMemoryAllocateFlagsInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo create(long address) {
        return new VkMemoryAllocateFlagsInfo(address, null);
    }

    @Nullable
    public static VkMemoryAllocateFlagsInfo createSafe(long address) {
        return address == 0L ? null : VkMemoryAllocateFlagsInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryAllocateFlagsInfo.create(VkMemoryAllocateFlagsInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryAllocateFlagsInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryAllocateFlagsInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryAllocateFlagsInfo.create(address, capacity);
    }

    public static VkMemoryAllocateFlagsInfo mallocStack() {
        return VkMemoryAllocateFlagsInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfo callocStack() {
        return VkMemoryAllocateFlagsInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfo mallocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo callocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int ndeviceMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndeviceMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateFlagsInfo.__struct(VkMemoryAllocateFlagsInfo.__member(4), VkMemoryAllocateFlagsInfo.__member(POINTER_SIZE), VkMemoryAllocateFlagsInfo.__member(4), VkMemoryAllocateFlagsInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DEVICEMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateFlagsInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryAllocateFlagsInfo newInstance(long address) {
            return new VkMemoryAllocateFlagsInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryAllocateFlagsInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryAllocateFlagsInfo.npNext(this.address());
        }

        @NativeType(value="VkMemoryAllocateFlags")
        public int flags() {
            return VkMemoryAllocateFlagsInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
            VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

