/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkInputAttachmentAspectReference
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBPASS;
    public static final int INPUTATTACHMENTINDEX;
    public static final int ASPECTMASK;

    VkInputAttachmentAspectReference(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkInputAttachmentAspectReference(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkInputAttachmentAspectReference.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int subpass() {
        return VkInputAttachmentAspectReference.nsubpass(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentIndex() {
        return VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address());
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkInputAttachmentAspectReference.naspectMask(this.address());
    }

    public VkInputAttachmentAspectReference subpass(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReference.nsubpass(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkInputAttachmentAspectReference.naspectMask(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference set(int subpass, int inputAttachmentIndex, int aspectMask) {
        this.subpass(subpass);
        this.inputAttachmentIndex(inputAttachmentIndex);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkInputAttachmentAspectReference set(VkInputAttachmentAspectReference src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkInputAttachmentAspectReference malloc() {
        return VkInputAttachmentAspectReference.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkInputAttachmentAspectReference calloc() {
        return VkInputAttachmentAspectReference.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkInputAttachmentAspectReference create() {
        return new VkInputAttachmentAspectReference(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkInputAttachmentAspectReference create(long address) {
        return new VkInputAttachmentAspectReference(address, null);
    }

    @Nullable
    public static VkInputAttachmentAspectReference createSafe(long address) {
        return address == 0L ? null : VkInputAttachmentAspectReference.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkInputAttachmentAspectReference.create(VkInputAttachmentAspectReference.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkInputAttachmentAspectReference.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkInputAttachmentAspectReference.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkInputAttachmentAspectReference.create(address, capacity);
    }

    public static VkInputAttachmentAspectReference mallocStack() {
        return VkInputAttachmentAspectReference.mallocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReference callocStack() {
        return VkInputAttachmentAspectReference.callocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReference mallocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReference.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkInputAttachmentAspectReference callocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReference.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkInputAttachmentAspectReference.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkInputAttachmentAspectReference.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReference.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReference.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASS);
    }

    public static int ninputAttachmentIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INPUTATTACHMENTINDEX);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTMASK);
    }

    public static void nsubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASS, value);
    }

    public static void ninputAttachmentIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INPUTATTACHMENTINDEX, value);
    }

    public static void naspectMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ASPECTMASK, value);
    }

    static {
        Struct.Layout layout = VkInputAttachmentAspectReference.__struct(VkInputAttachmentAspectReference.__member(4), VkInputAttachmentAspectReference.__member(4), VkInputAttachmentAspectReference.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBPASS = layout.offsetof(0);
        INPUTATTACHMENTINDEX = layout.offsetof(1);
        ASPECTMASK = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkInputAttachmentAspectReference, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkInputAttachmentAspectReference newInstance(long address) {
            return new VkInputAttachmentAspectReference(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int subpass() {
            return VkInputAttachmentAspectReference.nsubpass(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentIndex() {
            return VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address());
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkInputAttachmentAspectReference.naspectMask(this.address());
        }

        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReference.nsubpass(this.address(), value);
            return this;
        }

        public Buffer inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address(), value);
            return this;
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkInputAttachmentAspectReference.naspectMask(this.address(), value);
            return this;
        }
    }
}

