/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkIndirectCommandsTokenNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOKENTYPE;
    public static final int BUFFER;
    public static final int OFFSET;

    VkIndirectCommandsTokenNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkIndirectCommandsTokenNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkIndirectCommandsTokenNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkIndirectCommandsTokenTypeNVX")
    public int tokenType() {
        return VkIndirectCommandsTokenNVX.ntokenType(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkIndirectCommandsTokenNVX.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkIndirectCommandsTokenNVX.noffset(this.address());
    }

    public VkIndirectCommandsTokenNVX tokenType(@NativeType(value="VkIndirectCommandsTokenTypeNVX") int value) {
        VkIndirectCommandsTokenNVX.ntokenType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsTokenNVX buffer(@NativeType(value="VkBuffer") long value) {
        VkIndirectCommandsTokenNVX.nbuffer(this.address(), value);
        return this;
    }

    public VkIndirectCommandsTokenNVX offset(@NativeType(value="VkDeviceSize") long value) {
        VkIndirectCommandsTokenNVX.noffset(this.address(), value);
        return this;
    }

    public VkIndirectCommandsTokenNVX set(int tokenType, long buffer, long offset) {
        this.tokenType(tokenType);
        this.buffer(buffer);
        this.offset(offset);
        return this;
    }

    public VkIndirectCommandsTokenNVX set(VkIndirectCommandsTokenNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkIndirectCommandsTokenNVX malloc() {
        return VkIndirectCommandsTokenNVX.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkIndirectCommandsTokenNVX calloc() {
        return VkIndirectCommandsTokenNVX.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkIndirectCommandsTokenNVX create() {
        return new VkIndirectCommandsTokenNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkIndirectCommandsTokenNVX create(long address) {
        return new VkIndirectCommandsTokenNVX(address, null);
    }

    @Nullable
    public static VkIndirectCommandsTokenNVX createSafe(long address) {
        return address == 0L ? null : VkIndirectCommandsTokenNVX.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkIndirectCommandsTokenNVX.create(VkIndirectCommandsTokenNVX.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkIndirectCommandsTokenNVX.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkIndirectCommandsTokenNVX.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkIndirectCommandsTokenNVX.create(address, capacity);
    }

    public static VkIndirectCommandsTokenNVX mallocStack() {
        return VkIndirectCommandsTokenNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsTokenNVX callocStack() {
        return VkIndirectCommandsTokenNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsTokenNVX mallocStack(MemoryStack stack) {
        return VkIndirectCommandsTokenNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkIndirectCommandsTokenNVX callocStack(MemoryStack stack) {
        return VkIndirectCommandsTokenNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkIndirectCommandsTokenNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkIndirectCommandsTokenNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkIndirectCommandsTokenNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkIndirectCommandsTokenNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntokenType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOKENTYPE);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static void ntokenType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TOKENTYPE, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    static {
        Struct.Layout layout = VkIndirectCommandsTokenNVX.__struct(VkIndirectCommandsTokenNVX.__member(4), VkIndirectCommandsTokenNVX.__member(8), VkIndirectCommandsTokenNVX.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOKENTYPE = layout.offsetof(0);
        BUFFER = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsTokenNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkIndirectCommandsTokenNVX newInstance(long address) {
            return new VkIndirectCommandsTokenNVX(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkIndirectCommandsTokenTypeNVX")
        public int tokenType() {
            return VkIndirectCommandsTokenNVX.ntokenType(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkIndirectCommandsTokenNVX.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkIndirectCommandsTokenNVX.noffset(this.address());
        }

        public Buffer tokenType(@NativeType(value="VkIndirectCommandsTokenTypeNVX") int value) {
            VkIndirectCommandsTokenNVX.ntokenType(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkIndirectCommandsTokenNVX.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkIndirectCommandsTokenNVX.noffset(this.address(), value);
            return this;
        }
    }
}

