/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportFenceWin32HandleInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FENCE;
    public static final int FLAGS;
    public static final int HANDLETYPE;
    public static final int HANDLE;
    public static final int NAME;

    VkImportFenceWin32HandleInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImportFenceWin32HandleInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImportFenceWin32HandleInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportFenceWin32HandleInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportFenceWin32HandleInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkFence")
    public long fence() {
        return VkImportFenceWin32HandleInfoKHR.nfence(this.address());
    }

    @NativeType(value="VkFenceImportFlags")
    public int flags() {
        return VkImportFenceWin32HandleInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkExternalFenceHandleTypeFlagBits")
    public int handleType() {
        return VkImportFenceWin32HandleInfoKHR.nhandleType(this.address());
    }

    @NativeType(value="HANDLE")
    public long handle() {
        return VkImportFenceWin32HandleInfoKHR.nhandle(this.address());
    }

    @NativeType(value="LPCWSTR")
    public ByteBuffer name() {
        return VkImportFenceWin32HandleInfoKHR.nname(this.address());
    }

    @NativeType(value="LPCWSTR")
    public String nameString() {
        return VkImportFenceWin32HandleInfoKHR.nnameString(this.address());
    }

    public VkImportFenceWin32HandleInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImportFenceWin32HandleInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImportFenceWin32HandleInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR fence(@NativeType(value="VkFence") long value) {
        VkImportFenceWin32HandleInfoKHR.nfence(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR flags(@NativeType(value="VkFenceImportFlags") int value) {
        VkImportFenceWin32HandleInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR handleType(@NativeType(value="VkExternalFenceHandleTypeFlagBits") int value) {
        VkImportFenceWin32HandleInfoKHR.nhandleType(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR handle(@NativeType(value="HANDLE") long value) {
        VkImportFenceWin32HandleInfoKHR.nhandle(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR name(@NativeType(value="LPCWSTR") ByteBuffer value) {
        VkImportFenceWin32HandleInfoKHR.nname(this.address(), value);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR set(int sType, long pNext, long fence, int flags, int handleType, long handle, ByteBuffer name) {
        this.sType(sType);
        this.pNext(pNext);
        this.fence(fence);
        this.flags(flags);
        this.handleType(handleType);
        this.handle(handle);
        this.name(name);
        return this;
    }

    public VkImportFenceWin32HandleInfoKHR set(VkImportFenceWin32HandleInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportFenceWin32HandleInfoKHR malloc() {
        return VkImportFenceWin32HandleInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImportFenceWin32HandleInfoKHR calloc() {
        return VkImportFenceWin32HandleInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImportFenceWin32HandleInfoKHR create() {
        return new VkImportFenceWin32HandleInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImportFenceWin32HandleInfoKHR create(long address) {
        return new VkImportFenceWin32HandleInfoKHR(address, null);
    }

    @Nullable
    public static VkImportFenceWin32HandleInfoKHR createSafe(long address) {
        return address == 0L ? null : VkImportFenceWin32HandleInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.create(VkImportFenceWin32HandleInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImportFenceWin32HandleInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImportFenceWin32HandleInfoKHR.create(address, capacity);
    }

    public static VkImportFenceWin32HandleInfoKHR mallocStack() {
        return VkImportFenceWin32HandleInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkImportFenceWin32HandleInfoKHR callocStack() {
        return VkImportFenceWin32HandleInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkImportFenceWin32HandleInfoKHR mallocStack(MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImportFenceWin32HandleInfoKHR callocStack(MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImportFenceWin32HandleInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportFenceWin32HandleInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nfence(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FENCE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nhandleType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPE);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT2(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF16(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nfence(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FENCE, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nhandleType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPE, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkImportFenceWin32HandleInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkImportFenceWin32HandleInfoKHR.__struct(VkImportFenceWin32HandleInfoKHR.__member(4), VkImportFenceWin32HandleInfoKHR.__member(POINTER_SIZE), VkImportFenceWin32HandleInfoKHR.__member(8), VkImportFenceWin32HandleInfoKHR.__member(4), VkImportFenceWin32HandleInfoKHR.__member(4), VkImportFenceWin32HandleInfoKHR.__member(POINTER_SIZE), VkImportFenceWin32HandleInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FENCE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        HANDLETYPE = layout.offsetof(4);
        HANDLE = layout.offsetof(5);
        NAME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkImportFenceWin32HandleInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImportFenceWin32HandleInfoKHR newInstance(long address) {
            return new VkImportFenceWin32HandleInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportFenceWin32HandleInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportFenceWin32HandleInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkFence")
        public long fence() {
            return VkImportFenceWin32HandleInfoKHR.nfence(this.address());
        }

        @NativeType(value="VkFenceImportFlags")
        public int flags() {
            return VkImportFenceWin32HandleInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkExternalFenceHandleTypeFlagBits")
        public int handleType() {
            return VkImportFenceWin32HandleInfoKHR.nhandleType(this.address());
        }

        @NativeType(value="HANDLE")
        public long handle() {
            return VkImportFenceWin32HandleInfoKHR.nhandle(this.address());
        }

        @NativeType(value="LPCWSTR")
        public ByteBuffer name() {
            return VkImportFenceWin32HandleInfoKHR.nname(this.address());
        }

        @NativeType(value="LPCWSTR")
        public String nameString() {
            return VkImportFenceWin32HandleInfoKHR.nnameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportFenceWin32HandleInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportFenceWin32HandleInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer fence(@NativeType(value="VkFence") long value) {
            VkImportFenceWin32HandleInfoKHR.nfence(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkFenceImportFlags") int value) {
            VkImportFenceWin32HandleInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalFenceHandleTypeFlagBits") int value) {
            VkImportFenceWin32HandleInfoKHR.nhandleType(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="HANDLE") long value) {
            VkImportFenceWin32HandleInfoKHR.nhandle(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="LPCWSTR") ByteBuffer value) {
            VkImportFenceWin32HandleInfoKHR.nname(this.address(), value);
            return this;
        }
    }
}

