/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkImageViewUsageCreateInfo;

public class VkImageViewUsageCreateInfoKHR
extends VkImageViewUsageCreateInfo {
    VkImageViewUsageCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImageViewUsageCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageViewUsageCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkImageViewUsageCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImageViewUsageCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImageViewUsageCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkImageViewUsageCreateInfoKHR.nusage(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR set(int sType, long pNext, int usage) {
        this.sType(sType);
        this.pNext(pNext);
        this.usage(usage);
        return this;
    }

    public VkImageViewUsageCreateInfoKHR set(VkImageViewUsageCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageViewUsageCreateInfoKHR malloc() {
        return VkImageViewUsageCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageViewUsageCreateInfoKHR calloc() {
        return VkImageViewUsageCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageViewUsageCreateInfoKHR create() {
        return new VkImageViewUsageCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageViewUsageCreateInfoKHR create(long address) {
        return new VkImageViewUsageCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkImageViewUsageCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkImageViewUsageCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageViewUsageCreateInfoKHR.create(VkImageViewUsageCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageViewUsageCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImageViewUsageCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageViewUsageCreateInfoKHR.create(address, capacity);
    }

    public static VkImageViewUsageCreateInfoKHR mallocStack() {
        return VkImageViewUsageCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageViewUsageCreateInfoKHR callocStack() {
        return VkImageViewUsageCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkImageViewUsageCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageViewUsageCreateInfoKHR callocStack(MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageViewUsageCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageViewUsageCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkImageViewUsageCreateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageViewUsageCreateInfoKHR newInstance(long address) {
            return new VkImageViewUsageCreateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageViewUsageCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageViewUsageCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkImageViewUsageCreateInfoKHR.nusage(this.address(), value);
            return this;
        }
    }
}

