/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageMemoryRequirementsInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;

    VkImageMemoryRequirementsInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImageMemoryRequirementsInfo2(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageMemoryRequirementsInfo2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageMemoryRequirementsInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageMemoryRequirementsInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkImageMemoryRequirementsInfo2.nimage(this.address());
    }

    public VkImageMemoryRequirementsInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkImageMemoryRequirementsInfo2.nsType(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 pNext(@NativeType(value="void const *") long value) {
        VkImageMemoryRequirementsInfo2.npNext(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 image(@NativeType(value="VkImage") long value) {
        VkImageMemoryRequirementsInfo2.nimage(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 set(int sType, long pNext, long image) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 set(VkImageMemoryRequirementsInfo2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageMemoryRequirementsInfo2 malloc() {
        return VkImageMemoryRequirementsInfo2.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2 calloc() {
        return VkImageMemoryRequirementsInfo2.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2 create() {
        return new VkImageMemoryRequirementsInfo2(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2 create(long address) {
        return new VkImageMemoryRequirementsInfo2(address, null);
    }

    @Nullable
    public static VkImageMemoryRequirementsInfo2 createSafe(long address) {
        return address == 0L ? null : VkImageMemoryRequirementsInfo2.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageMemoryRequirementsInfo2.create(VkImageMemoryRequirementsInfo2.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageMemoryRequirementsInfo2.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImageMemoryRequirementsInfo2.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageMemoryRequirementsInfo2.create(address, capacity);
    }

    public static VkImageMemoryRequirementsInfo2 mallocStack() {
        return VkImageMemoryRequirementsInfo2.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryRequirementsInfo2 callocStack() {
        return VkImageMemoryRequirementsInfo2.callocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryRequirementsInfo2 mallocStack(MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2 callocStack(MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    static {
        Struct.Layout layout = VkImageMemoryRequirementsInfo2.__struct(VkImageMemoryRequirementsInfo2.__member(4), VkImageMemoryRequirementsInfo2.__member(POINTER_SIZE), VkImageMemoryRequirementsInfo2.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImageMemoryRequirementsInfo2, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageMemoryRequirementsInfo2 newInstance(long address) {
            return new VkImageMemoryRequirementsInfo2(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageMemoryRequirementsInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageMemoryRequirementsInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkImageMemoryRequirementsInfo2.nimage(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageMemoryRequirementsInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageMemoryRequirementsInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkImageMemoryRequirementsInfo2.nimage(this.address(), value);
            return this;
        }
    }
}

