/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFormatProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LINEARTILINGFEATURES;
    public static final int OPTIMALTILINGFEATURES;
    public static final int BUFFERFEATURES;

    VkFormatProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkFormatProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkFormatProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int linearTilingFeatures() {
        return VkFormatProperties.nlinearTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int optimalTilingFeatures() {
        return VkFormatProperties.noptimalTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int bufferFeatures() {
        return VkFormatProperties.nbufferFeatures(this.address());
    }

    public static VkFormatProperties malloc() {
        return VkFormatProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkFormatProperties calloc() {
        return VkFormatProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkFormatProperties create() {
        return new VkFormatProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkFormatProperties create(long address) {
        return new VkFormatProperties(address, null);
    }

    @Nullable
    public static VkFormatProperties createSafe(long address) {
        return address == 0L ? null : VkFormatProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkFormatProperties.create(VkFormatProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFormatProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkFormatProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkFormatProperties.create(address, capacity);
    }

    public static VkFormatProperties mallocStack() {
        return VkFormatProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkFormatProperties callocStack() {
        return VkFormatProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkFormatProperties mallocStack(MemoryStack stack) {
        return VkFormatProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFormatProperties callocStack(MemoryStack stack) {
        return VkFormatProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFormatProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFormatProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlinearTilingFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LINEARTILINGFEATURES);
    }

    public static int noptimalTilingFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OPTIMALTILINGFEATURES);
    }

    public static int nbufferFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFERFEATURES);
    }

    static {
        Struct.Layout layout = VkFormatProperties.__struct(VkFormatProperties.__member(4), VkFormatProperties.__member(4), VkFormatProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LINEARTILINGFEATURES = layout.offsetof(0);
        OPTIMALTILINGFEATURES = layout.offsetof(1);
        BUFFERFEATURES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkFormatProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkFormatProperties newInstance(long address) {
            return new VkFormatProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int linearTilingFeatures() {
            return VkFormatProperties.nlinearTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int optimalTilingFeatures() {
            return VkFormatProperties.noptimalTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int bufferFeatures() {
            return VkFormatProperties.nbufferFeatures(this.address());
        }
    }
}

