/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfo;

public class VkExternalMemoryImageCreateInfoKHR
extends VkExternalMemoryImageCreateInfo {
    VkExternalMemoryImageCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryImageCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryImageCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryImageCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryImageCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryImageCreateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryImageCreateInfoKHR set(VkExternalMemoryImageCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryImageCreateInfoKHR malloc() {
        return VkExternalMemoryImageCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR calloc() {
        return VkExternalMemoryImageCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR create() {
        return new VkExternalMemoryImageCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR create(long address) {
        return new VkExternalMemoryImageCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkExternalMemoryImageCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryImageCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.create(VkExternalMemoryImageCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalMemoryImageCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryImageCreateInfoKHR.create(address, capacity);
    }

    public static VkExternalMemoryImageCreateInfoKHR mallocStack() {
        return VkExternalMemoryImageCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfoKHR callocStack() {
        return VkExternalMemoryImageCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR callocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExternalMemoryImageCreateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryImageCreateInfoKHR newInstance(long address) {
            return new VkExternalMemoryImageCreateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryImageCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryImageCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryImageCreateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

