/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryImageCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExternalMemoryImageCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryImageCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryImageCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalMemoryImageCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExternalMemoryImageCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExternalMemoryImageCreateInfo.nhandleTypes(this.address());
    }

    public VkExternalMemoryImageCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryImageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryImageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryImageCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryImageCreateInfo set(VkExternalMemoryImageCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryImageCreateInfo malloc() {
        return VkExternalMemoryImageCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfo calloc() {
        return VkExternalMemoryImageCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfo create() {
        return new VkExternalMemoryImageCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfo create(long address) {
        return new VkExternalMemoryImageCreateInfo(address, null);
    }

    @Nullable
    public static VkExternalMemoryImageCreateInfo createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryImageCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryImageCreateInfo.create(VkExternalMemoryImageCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryImageCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalMemoryImageCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryImageCreateInfo.create(address, capacity);
    }

    public static VkExternalMemoryImageCreateInfo mallocStack() {
        return VkExternalMemoryImageCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfo callocStack() {
        return VkExternalMemoryImageCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfo mallocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfo callocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryImageCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryImageCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryImageCreateInfo.__struct(VkExternalMemoryImageCreateInfo.__member(4), VkExternalMemoryImageCreateInfo.__member(POINTER_SIZE), VkExternalMemoryImageCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryImageCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryImageCreateInfo newInstance(long address) {
            return new VkExternalMemoryImageCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalMemoryImageCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExternalMemoryImageCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExternalMemoryImageCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryImageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryImageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryImageCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

