/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportMemoryAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExportMemoryAllocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExportMemoryAllocateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExportMemoryAllocateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportMemoryAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportMemoryAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExportMemoryAllocateInfo.nhandleTypes(this.address());
    }

    public VkExportMemoryAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExportMemoryAllocateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportMemoryAllocateInfo set(VkExportMemoryAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryAllocateInfo malloc() {
        return VkExportMemoryAllocateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportMemoryAllocateInfo calloc() {
        return VkExportMemoryAllocateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportMemoryAllocateInfo create() {
        return new VkExportMemoryAllocateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExportMemoryAllocateInfo create(long address) {
        return new VkExportMemoryAllocateInfo(address, null);
    }

    @Nullable
    public static VkExportMemoryAllocateInfo createSafe(long address) {
        return address == 0L ? null : VkExportMemoryAllocateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportMemoryAllocateInfo.create(VkExportMemoryAllocateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportMemoryAllocateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExportMemoryAllocateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportMemoryAllocateInfo.create(address, capacity);
    }

    public static VkExportMemoryAllocateInfo mallocStack() {
        return VkExportMemoryAllocateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfo callocStack() {
        return VkExportMemoryAllocateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfo mallocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportMemoryAllocateInfo callocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryAllocateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExportMemoryAllocateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExportMemoryAllocateInfo.__struct(VkExportMemoryAllocateInfo.__member(4), VkExportMemoryAllocateInfo.__member(POINTER_SIZE), VkExportMemoryAllocateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExportMemoryAllocateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExportMemoryAllocateInfo newInstance(long address) {
            return new VkExportMemoryAllocateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportMemoryAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportMemoryAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExportMemoryAllocateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExportMemoryAllocateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

