/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportFenceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExportFenceCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExportFenceCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExportFenceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportFenceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportFenceCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalFenceHandleTypeFlags")
    public int handleTypes() {
        return VkExportFenceCreateInfo.nhandleTypes(this.address());
    }

    public VkExportFenceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExportFenceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExportFenceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExportFenceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExportFenceCreateInfo handleTypes(@NativeType(value="VkExternalFenceHandleTypeFlags") int value) {
        VkExportFenceCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExportFenceCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportFenceCreateInfo set(VkExportFenceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportFenceCreateInfo malloc() {
        return VkExportFenceCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportFenceCreateInfo calloc() {
        return VkExportFenceCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportFenceCreateInfo create() {
        return new VkExportFenceCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExportFenceCreateInfo create(long address) {
        return new VkExportFenceCreateInfo(address, null);
    }

    @Nullable
    public static VkExportFenceCreateInfo createSafe(long address) {
        return address == 0L ? null : VkExportFenceCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportFenceCreateInfo.create(VkExportFenceCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportFenceCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExportFenceCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportFenceCreateInfo.create(address, capacity);
    }

    public static VkExportFenceCreateInfo mallocStack() {
        return VkExportFenceCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkExportFenceCreateInfo callocStack() {
        return VkExportFenceCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkExportFenceCreateInfo mallocStack(MemoryStack stack) {
        return VkExportFenceCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportFenceCreateInfo callocStack(MemoryStack stack) {
        return VkExportFenceCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExportFenceCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExportFenceCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExportFenceCreateInfo.__struct(VkExportFenceCreateInfo.__member(4), VkExportFenceCreateInfo.__member(POINTER_SIZE), VkExportFenceCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExportFenceCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExportFenceCreateInfo newInstance(long address) {
            return new VkExportFenceCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportFenceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportFenceCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalFenceHandleTypeFlags")
        public int handleTypes() {
            return VkExportFenceCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportFenceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportFenceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalFenceHandleTypeFlags") int value) {
            VkExportFenceCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

