/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceQueueInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUEUEFAMILYINDEX;
    public static final int QUEUEINDEX;

    VkDeviceQueueInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceQueueInfo2(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceQueueInfo2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceQueueInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceQueueInfo2.npNext(this.address());
    }

    @NativeType(value="VkDeviceQueueCreateFlags")
    public int flags() {
        return VkDeviceQueueInfo2.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkDeviceQueueInfo2.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueIndex() {
        return VkDeviceQueueInfo2.nqueueIndex(this.address());
    }

    public VkDeviceQueueInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceQueueInfo2.nsType(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 pNext(@NativeType(value="void const *") long value) {
        VkDeviceQueueInfo2.npNext(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
        VkDeviceQueueInfo2.nflags(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceQueueInfo2.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 queueIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceQueueInfo2.nqueueIndex(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 set(int sType, long pNext, int flags, int queueFamilyIndex, int queueIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queueFamilyIndex(queueFamilyIndex);
        this.queueIndex(queueIndex);
        return this;
    }

    public VkDeviceQueueInfo2 set(VkDeviceQueueInfo2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceQueueInfo2 malloc() {
        return VkDeviceQueueInfo2.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceQueueInfo2 calloc() {
        return VkDeviceQueueInfo2.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceQueueInfo2 create() {
        return new VkDeviceQueueInfo2(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceQueueInfo2 create(long address) {
        return new VkDeviceQueueInfo2(address, null);
    }

    @Nullable
    public static VkDeviceQueueInfo2 createSafe(long address) {
        return address == 0L ? null : VkDeviceQueueInfo2.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceQueueInfo2.create(VkDeviceQueueInfo2.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceQueueInfo2.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceQueueInfo2.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceQueueInfo2.create(address, capacity);
    }

    public static VkDeviceQueueInfo2 mallocStack() {
        return VkDeviceQueueInfo2.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceQueueInfo2 callocStack() {
        return VkDeviceQueueInfo2.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceQueueInfo2 mallocStack(MemoryStack stack) {
        return VkDeviceQueueInfo2.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceQueueInfo2 callocStack(MemoryStack stack) {
        return VkDeviceQueueInfo2.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceQueueInfo2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceQueueInfo2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueInfo2.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueInfo2.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nqueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEFAMILYINDEX);
    }

    public static int nqueueIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUEFAMILYINDEX, value);
    }

    public static void nqueueIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUEINDEX, value);
    }

    static {
        Struct.Layout layout = VkDeviceQueueInfo2.__struct(VkDeviceQueueInfo2.__member(4), VkDeviceQueueInfo2.__member(POINTER_SIZE), VkDeviceQueueInfo2.__member(4), VkDeviceQueueInfo2.__member(4), VkDeviceQueueInfo2.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUEUEFAMILYINDEX = layout.offsetof(3);
        QUEUEINDEX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceQueueInfo2, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceQueueInfo2 newInstance(long address) {
            return new VkDeviceQueueInfo2(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceQueueInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceQueueInfo2.npNext(this.address());
        }

        @NativeType(value="VkDeviceQueueCreateFlags")
        public int flags() {
            return VkDeviceQueueInfo2.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkDeviceQueueInfo2.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueIndex() {
            return VkDeviceQueueInfo2.nqueueIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceQueueInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceQueueInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
            VkDeviceQueueInfo2.nflags(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceQueueInfo2.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer queueIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceQueueInfo2.nqueueIndex(this.address(), value);
            return this;
        }
    }
}

