/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceQueueCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUEUEFAMILYINDEX;
    public static final int QUEUECOUNT;
    public static final int PQUEUEPRIORITIES;

    VkDeviceQueueCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceQueueCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceQueueCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceQueueCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceQueueCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDeviceQueueCreateFlags")
    public int flags() {
        return VkDeviceQueueCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueCount() {
        return VkDeviceQueueCreateInfo.nqueueCount(this.address());
    }

    @NativeType(value="float const *")
    public FloatBuffer pQueuePriorities() {
        return VkDeviceQueueCreateInfo.npQueuePriorities(this.address());
    }

    public VkDeviceQueueCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceQueueCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceQueueCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
        VkDeviceQueueCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo pQueuePriorities(@NativeType(value="float const *") FloatBuffer value) {
        VkDeviceQueueCreateInfo.npQueuePriorities(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo set(int sType, long pNext, int flags, int queueFamilyIndex, FloatBuffer pQueuePriorities) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queueFamilyIndex(queueFamilyIndex);
        this.pQueuePriorities(pQueuePriorities);
        return this;
    }

    public VkDeviceQueueCreateInfo set(VkDeviceQueueCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceQueueCreateInfo malloc() {
        return VkDeviceQueueCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceQueueCreateInfo calloc() {
        return VkDeviceQueueCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceQueueCreateInfo create() {
        return new VkDeviceQueueCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceQueueCreateInfo create(long address) {
        return new VkDeviceQueueCreateInfo(address, null);
    }

    @Nullable
    public static VkDeviceQueueCreateInfo createSafe(long address) {
        return address == 0L ? null : VkDeviceQueueCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceQueueCreateInfo.create(VkDeviceQueueCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceQueueCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceQueueCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceQueueCreateInfo.create(address, capacity);
    }

    public static VkDeviceQueueCreateInfo mallocStack() {
        return VkDeviceQueueCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceQueueCreateInfo callocStack() {
        return VkDeviceQueueCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceQueueCreateInfo mallocStack(MemoryStack stack) {
        return VkDeviceQueueCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceQueueCreateInfo callocStack(MemoryStack stack) {
        return VkDeviceQueueCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceQueueCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceQueueCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nqueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEFAMILYINDEX);
    }

    public static int nqueueCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUECOUNT);
    }

    public static FloatBuffer npQueuePriorities(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)PQUEUEPRIORITIES), VkDeviceQueueCreateInfo.nqueueCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUEFAMILYINDEX, value);
    }

    public static void nqueueCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUECOUNT, value);
    }

    public static void npQueuePriorities(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUEPRIORITIES, MemoryUtil.memAddress(value));
        VkDeviceQueueCreateInfo.nqueueCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PQUEUEPRIORITIES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceQueueCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceQueueCreateInfo.__struct(VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(POINTER_SIZE), VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUEUEFAMILYINDEX = layout.offsetof(3);
        QUEUECOUNT = layout.offsetof(4);
        PQUEUEPRIORITIES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceQueueCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceQueueCreateInfo newInstance(long address) {
            return new VkDeviceQueueCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceQueueCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceQueueCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDeviceQueueCreateFlags")
        public int flags() {
            return VkDeviceQueueCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueCount() {
            return VkDeviceQueueCreateInfo.nqueueCount(this.address());
        }

        @NativeType(value="float const *")
        public FloatBuffer pQueuePriorities() {
            return VkDeviceQueueCreateInfo.npQueuePriorities(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceQueueCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceQueueCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
            VkDeviceQueueCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer pQueuePriorities(@NativeType(value="float const *") FloatBuffer value) {
            VkDeviceQueueCreateInfo.npQueuePriorities(this.address(), value);
            return this;
        }
    }
}

