/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupPresentCapabilitiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRESENTMASK;
    public static final int MODES;

    VkDeviceGroupPresentCapabilitiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupPresentCapabilitiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupPresentCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t[VK_MAX_DEVICE_GROUP_SIZE]")
    public IntBuffer presentMask() {
        return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int presentMask(int index) {
        return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address(), index);
    }

    @NativeType(value="VkDeviceGroupPresentModeFlagsKHR")
    public int modes() {
        return VkDeviceGroupPresentCapabilitiesKHR.nmodes(this.address());
    }

    public VkDeviceGroupPresentCapabilitiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentCapabilitiesKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentCapabilitiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkDeviceGroupPresentCapabilitiesKHR set(VkDeviceGroupPresentCapabilitiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupPresentCapabilitiesKHR malloc() {
        return VkDeviceGroupPresentCapabilitiesKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHR calloc() {
        return VkDeviceGroupPresentCapabilitiesKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHR create() {
        return new VkDeviceGroupPresentCapabilitiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHR create(long address) {
        return new VkDeviceGroupPresentCapabilitiesKHR(address, null);
    }

    @Nullable
    public static VkDeviceGroupPresentCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupPresentCapabilitiesKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.create(VkDeviceGroupPresentCapabilitiesKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupPresentCapabilitiesKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupPresentCapabilitiesKHR.create(address, capacity);
    }

    public static VkDeviceGroupPresentCapabilitiesKHR mallocStack() {
        return VkDeviceGroupPresentCapabilitiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentCapabilitiesKHR callocStack() {
        return VkDeviceGroupPresentCapabilitiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentCapabilitiesKHR mallocStack(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHR callocStack(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static IntBuffer npresentMask(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)PRESENTMASK, 32);
    }

    public static int npresentMask(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)PRESENTMASK + Checks.check(index, 32) * 4L);
    }

    public static int nmodes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkDeviceGroupPresentCapabilitiesKHR.__struct(VkDeviceGroupPresentCapabilitiesKHR.__member(4), VkDeviceGroupPresentCapabilitiesKHR.__member(POINTER_SIZE), VkDeviceGroupPresentCapabilitiesKHR.__array(4, 32), VkDeviceGroupPresentCapabilitiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRESENTMASK = layout.offsetof(2);
        MODES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupPresentCapabilitiesKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupPresentCapabilitiesKHR newInstance(long address) {
            return new VkDeviceGroupPresentCapabilitiesKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t[VK_MAX_DEVICE_GROUP_SIZE]")
        public IntBuffer presentMask() {
            return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int presentMask(int index) {
            return VkDeviceGroupPresentCapabilitiesKHR.npresentMask(this.address(), index);
        }

        @NativeType(value="VkDeviceGroupPresentModeFlagsKHR")
        public int modes() {
            return VkDeviceGroupPresentCapabilitiesKHR.nmodes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupPresentCapabilitiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupPresentCapabilitiesKHR.npNext(this.address(), value);
            return this;
        }
    }
}

