/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupDeviceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHYSICALDEVICECOUNT;
    public static final int PPHYSICALDEVICES;

    VkDeviceGroupDeviceCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupDeviceCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupDeviceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupDeviceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupDeviceCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int physicalDeviceCount() {
        return VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPhysicalDevice const *")
    public PointerBuffer pPhysicalDevices() {
        return VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address());
    }

    public VkDeviceGroupDeviceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupDeviceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupDeviceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo pPhysicalDevices(@Nullable @NativeType(value="VkPhysicalDevice const *") PointerBuffer value) {
        VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo set(int sType, long pNext, @Nullable PointerBuffer pPhysicalDevices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pPhysicalDevices(pPhysicalDevices);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo set(VkDeviceGroupDeviceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupDeviceCreateInfo malloc() {
        return VkDeviceGroupDeviceCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfo calloc() {
        return VkDeviceGroupDeviceCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfo create() {
        return new VkDeviceGroupDeviceCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfo create(long address) {
        return new VkDeviceGroupDeviceCreateInfo(address, null);
    }

    @Nullable
    public static VkDeviceGroupDeviceCreateInfo createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupDeviceCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.create(VkDeviceGroupDeviceCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupDeviceCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupDeviceCreateInfo.create(address, capacity);
    }

    public static VkDeviceGroupDeviceCreateInfo mallocStack() {
        return VkDeviceGroupDeviceCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfo callocStack() {
        return VkDeviceGroupDeviceCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nphysicalDeviceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PHYSICALDEVICECOUNT);
    }

    @Nullable
    public static PointerBuffer npPhysicalDevices(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPHYSICALDEVICES), VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nphysicalDeviceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PHYSICALDEVICECOUNT, value);
    }

    public static void npPhysicalDevices(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPHYSICALDEVICES, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPHYSICALDEVICES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupDeviceCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupDeviceCreateInfo.__struct(VkDeviceGroupDeviceCreateInfo.__member(4), VkDeviceGroupDeviceCreateInfo.__member(POINTER_SIZE), VkDeviceGroupDeviceCreateInfo.__member(4), VkDeviceGroupDeviceCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHYSICALDEVICECOUNT = layout.offsetof(2);
        PPHYSICALDEVICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupDeviceCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupDeviceCreateInfo newInstance(long address) {
            return new VkDeviceGroupDeviceCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupDeviceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupDeviceCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int physicalDeviceCount() {
            return VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPhysicalDevice const *")
        public PointerBuffer pPhysicalDevices() {
            return VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupDeviceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupDeviceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pPhysicalDevices(@Nullable @NativeType(value="VkPhysicalDevice const *") PointerBuffer value) {
            VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address(), value);
            return this;
        }
    }
}

