/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupCommandBufferBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEMASK;

    VkDeviceGroupCommandBufferBeginInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupCommandBufferBeginInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupCommandBufferBeginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupCommandBufferBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupCommandBufferBeginInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkDeviceGroupCommandBufferBeginInfo.ndeviceMask(this.address());
    }

    public VkDeviceGroupCommandBufferBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupCommandBufferBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupCommandBufferBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupCommandBufferBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupCommandBufferBeginInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupCommandBufferBeginInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkDeviceGroupCommandBufferBeginInfo set(int sType, long pNext, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkDeviceGroupCommandBufferBeginInfo set(VkDeviceGroupCommandBufferBeginInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupCommandBufferBeginInfo malloc() {
        return VkDeviceGroupCommandBufferBeginInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupCommandBufferBeginInfo calloc() {
        return VkDeviceGroupCommandBufferBeginInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupCommandBufferBeginInfo create() {
        return new VkDeviceGroupCommandBufferBeginInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupCommandBufferBeginInfo create(long address) {
        return new VkDeviceGroupCommandBufferBeginInfo(address, null);
    }

    @Nullable
    public static VkDeviceGroupCommandBufferBeginInfo createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupCommandBufferBeginInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupCommandBufferBeginInfo.create(VkDeviceGroupCommandBufferBeginInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupCommandBufferBeginInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupCommandBufferBeginInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupCommandBufferBeginInfo.create(address, capacity);
    }

    public static VkDeviceGroupCommandBufferBeginInfo mallocStack() {
        return VkDeviceGroupCommandBufferBeginInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupCommandBufferBeginInfo callocStack() {
        return VkDeviceGroupCommandBufferBeginInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupCommandBufferBeginInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupCommandBufferBeginInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupCommandBufferBeginInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupCommandBufferBeginInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupCommandBufferBeginInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupCommandBufferBeginInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupCommandBufferBeginInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupCommandBufferBeginInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndeviceMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndeviceMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEMASK, value);
    }

    static {
        Struct.Layout layout = VkDeviceGroupCommandBufferBeginInfo.__struct(VkDeviceGroupCommandBufferBeginInfo.__member(4), VkDeviceGroupCommandBufferBeginInfo.__member(POINTER_SIZE), VkDeviceGroupCommandBufferBeginInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEMASK = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupCommandBufferBeginInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupCommandBufferBeginInfo newInstance(long address) {
            return new VkDeviceGroupCommandBufferBeginInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupCommandBufferBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupCommandBufferBeginInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkDeviceGroupCommandBufferBeginInfo.ndeviceMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupCommandBufferBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupCommandBufferBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupCommandBufferBeginInfo.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

