/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandleDevice;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VkDevice
extends DispatchableHandleDevice {
    private final VkPhysicalDevice physicalDevice;

    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci) {
        this(handle, physicalDevice, ci, 0);
    }

    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci, int apiVersion) {
        super(handle, VkDevice.getDeviceCapabilities(handle, physicalDevice, ci, apiVersion));
        this.physicalDevice = physicalDevice;
    }

    public VkPhysicalDevice getPhysicalDevice() {
        return this.physicalDevice;
    }

    private static VKCapabilitiesDevice getDeviceCapabilities(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci, int apiVersion) {
        long GetDeviceProcAddr;
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (apiVersion == 0) {
                long GetPhysicalDeviceProperties = JNI.callPPP(VK.getGlobalCommands().vkGetInstanceProcAddr, physicalDevice.getInstance().address(), MemoryUtil.memAddress(stack.ASCII("vkGetPhysicalDeviceProperties")));
                VkPhysicalDeviceProperties props = VkPhysicalDeviceProperties.callocStack(stack);
                JNI.callPPV(GetPhysicalDeviceProperties, physicalDevice.address(), props.address());
                apiVersion = props.apiVersion();
                if (apiVersion == 0) {
                    apiVersion = physicalDevice.getInstance().getCapabilities().apiVersion;
                }
            }
            GetDeviceProcAddr = JNI.callPPP(VK.getGlobalCommands().vkGetInstanceProcAddr, physicalDevice.getInstance().address(), MemoryUtil.memAddress(stack.ASCII("vkGetDeviceProcAddr")));
        }
        return new VKCapabilitiesDevice(functionName -> {
            long address = JNI.callPPP(GetDeviceProcAddr, handle, MemoryUtil.memAddress(functionName));
            if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for VK device function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }, physicalDevice.getCapabilities(), VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()));
    }
}

