/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorSetLayoutSupport
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUPPORTED;

    VkDescriptorSetLayoutSupport(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorSetLayoutSupport(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorSetLayoutSupport.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetLayoutSupport.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDescriptorSetLayoutSupport.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean supported() {
        return VkDescriptorSetLayoutSupport.nsupported(this.address()) != 0;
    }

    public VkDescriptorSetLayoutSupport sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutSupport.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutSupport pNext(@NativeType(value="void *") long value) {
        VkDescriptorSetLayoutSupport.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutSupport set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkDescriptorSetLayoutSupport set(VkDescriptorSetLayoutSupport src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutSupport malloc() {
        return VkDescriptorSetLayoutSupport.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorSetLayoutSupport calloc() {
        return VkDescriptorSetLayoutSupport.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorSetLayoutSupport create() {
        return new VkDescriptorSetLayoutSupport(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorSetLayoutSupport create(long address) {
        return new VkDescriptorSetLayoutSupport(address, null);
    }

    @Nullable
    public static VkDescriptorSetLayoutSupport createSafe(long address) {
        return address == 0L ? null : VkDescriptorSetLayoutSupport.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetLayoutSupport.create(VkDescriptorSetLayoutSupport.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetLayoutSupport.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorSetLayoutSupport.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorSetLayoutSupport.create(address, capacity);
    }

    public static VkDescriptorSetLayoutSupport mallocStack() {
        return VkDescriptorSetLayoutSupport.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutSupport callocStack() {
        return VkDescriptorSetLayoutSupport.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutSupport mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutSupport callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutSupport.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutSupport.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsupported(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTED);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutSupport.__struct(VkDescriptorSetLayoutSupport.__member(4), VkDescriptorSetLayoutSupport.__member(POINTER_SIZE), VkDescriptorSetLayoutSupport.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUPPORTED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutSupport, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorSetLayoutSupport newInstance(long address) {
            return new VkDescriptorSetLayoutSupport(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetLayoutSupport.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDescriptorSetLayoutSupport.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean supported() {
            return VkDescriptorSetLayoutSupport.nsupported(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutSupport.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDescriptorSetLayoutSupport.npNext(this.address(), value);
            return this;
        }
    }
}

