/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorSetLayoutBindingFlagsCreateInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BINDINGCOUNT;
    public static final int PBINDINGFLAGS;

    VkDescriptorSetLayoutBindingFlagsCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorSetLayoutBindingFlagsCreateInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindingCount() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nbindingCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorBindingFlagsEXT const *")
    public IntBuffer pBindingFlags() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npBindingFlags(this.address());
    }

    public VkDescriptorSetLayoutBindingFlagsCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBindingFlagsCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBindingFlagsCreateInfoEXT pBindingFlags(@Nullable @NativeType(value="VkDescriptorBindingFlagsEXT const *") IntBuffer value) {
        VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npBindingFlags(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBindingFlagsCreateInfoEXT set(int sType, long pNext, @Nullable IntBuffer pBindingFlags) {
        this.sType(sType);
        this.pNext(pNext);
        this.pBindingFlags(pBindingFlags);
        return this;
    }

    public VkDescriptorSetLayoutBindingFlagsCreateInfoEXT set(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT malloc() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT calloc() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT create() {
        return new VkDescriptorSetLayoutBindingFlagsCreateInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT create(long address) {
        return new VkDescriptorSetLayoutBindingFlagsCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(address, capacity);
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT mallocStack() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT callocStack() {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutBindingFlagsCreateInfoEXT callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nbindingCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDINGCOUNT);
    }

    @Nullable
    public static IntBuffer npBindingFlags(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PBINDINGFLAGS), VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nbindingCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbindingCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDINGCOUNT, value);
    }

    public static void npBindingFlags(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDINGFLAGS, MemoryUtil.memAddressSafe(value));
        VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nbindingCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nbindingCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PBINDINGFLAGS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__struct(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__member(4), VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__member(POINTER_SIZE), VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__member(4), VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BINDINGCOUNT = layout.offsetof(2);
        PBINDINGFLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutBindingFlagsCreateInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorSetLayoutBindingFlagsCreateInfoEXT newInstance(long address) {
            return new VkDescriptorSetLayoutBindingFlagsCreateInfoEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindingCount() {
            return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nbindingCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorBindingFlagsEXT const *")
        public IntBuffer pBindingFlags() {
            return VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npBindingFlags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pBindingFlags(@Nullable @NativeType(value="VkDescriptorBindingFlagsEXT const *") IntBuffer value) {
            VkDescriptorSetLayoutBindingFlagsCreateInfoEXT.npBindingFlags(this.address(), value);
            return this;
        }
    }
}

